/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RefreshStrategy {
    public boolean needsRefresh(long var1);

    public static class LogOnce
    extends Timed {
        private static final Logger log = LoggerFactory.getLogger(RefreshStrategy.class);
        private final Exception initStackTrace = new Exception("The session was created here:");
        private boolean warnIfIdle = true;

        public LogOnce(long interval) {
            super(interval);
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            if (super.needsRefresh(secondsSinceLastAccess) && this.warnIfIdle) {
                log.warn("This session has been idle for " + TimeUnit.MINUTES.convert(secondsSinceLastAccess, TimeUnit.SECONDS) + " minutes and might be out of date. " + "Consider using a fresh session or explicitly refresh the session.", (Throwable)this.initStackTrace);
                this.warnIfIdle = false;
            }
            return false;
        }
    }

    public static class Timed
    implements RefreshStrategy {
        private final long interval;

        public Timed(long interval) {
            this.interval = interval;
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            return secondsSinceLastAccess > this.interval;
        }
    }

    public static class Composite
    implements RefreshStrategy {
        private final RefreshStrategy[] refreshStrategies;

        public Composite(RefreshStrategy ... refreshStrategies) {
            this.refreshStrategies = refreshStrategies;
        }

        @Override
        public boolean needsRefresh(long secondsSinceLastAccess) {
            for (RefreshStrategy r : this.refreshStrategies) {
                if (!r.needsRefresh(secondsSinceLastAccess)) continue;
                return true;
            }
            return false;
        }
    }
}

