/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.jmx.SessionMBean;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;

public class SessionStats
implements SessionMBean {
    private final Exception initStackTrace = new Exception("The session was opened here:");
    private final AtomicReference<RepositoryException> lastFailedSave = new AtomicReference();
    private final SessionDelegate delegate;
    private final String sessionId;
    private final AuthInfo authInfo;
    private Map<String, Object> attributes = Collections.emptyMap();

    public SessionStats(SessionDelegate sessionDelegate) {
        this.delegate = sessionDelegate;
        this.sessionId = sessionDelegate.toString();
        this.authInfo = sessionDelegate.getAuthInfo();
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void failedSave(RepositoryException repositoryException) {
        this.lastFailedSave.set(repositoryException);
    }

    public String toString() {
        return this.getAuthInfo().getUserID() + '@' + this.sessionId + '@' + this.getLoginTimeStamp();
    }

    public String getInitStackTrace() {
        return SessionStats.format(this.initStackTrace);
    }

    public AuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getLoginTimeStamp() {
        return SessionStats.formatDate(this.delegate.getLoginTime());
    }

    public String getLastReadAccess() {
        return SessionStats.formatDate(this.delegate.getReadTime());
    }

    public long getReadCount() {
        return this.delegate.getReadCount();
    }

    public double getReadRate() {
        return this.calculateRate(this.getReadCount());
    }

    public String getLastWriteAccess() {
        return SessionStats.formatDate(this.delegate.getWriteTime());
    }

    public long getWriteCount() {
        return this.delegate.getWriteCount();
    }

    public double getWriteRate() {
        return this.calculateRate(this.getWriteCount());
    }

    public String getLastRefresh() {
        return SessionStats.formatDate(this.delegate.getRefreshTime());
    }

    public long getRefreshCount() {
        return this.delegate.getRefreshCount();
    }

    public double getRefreshRate() {
        return this.calculateRate(this.getRefreshCount());
    }

    public String getLastSave() {
        return SessionStats.formatDate(this.delegate.getSaveTime());
    }

    public long getSaveCount() {
        return this.delegate.getSaveCount();
    }

    public double getSaveRate() {
        return this.calculateRate(this.getSaveCount());
    }

    public String[] getSessionAttributes() {
        String[] atts = new String[this.attributes.size()];
        int k = 0;
        for (Map.Entry<String, Object> attribute : this.attributes.entrySet()) {
            atts[k++] = attribute.getKey() + '=' + attribute.getValue();
        }
        return atts;
    }

    public String getLastFailedSave() {
        return SessionStats.format((Exception)((Object)this.lastFailedSave.get()));
    }

    private static String formatDate(Date date) {
        return date == null ? "" : DateFormat.getDateTimeInstance().format(date);
    }

    private static String format(Exception exception) {
        if (exception == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private double calculateRate(long count) {
        double dt = this.delegate.getSecondsSinceLogin();
        if (dt > 0.0) {
            return (double)count / dt;
        }
        return Double.NaN;
    }
}

