/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.version;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.util.TraversingItemVisitor;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionHistoryDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionManagerDelegate;
import org.apache.jackrabbit.oak.jcr.session.SessionContext;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.jcr.version.VersionHistoryImpl;
import org.apache.jackrabbit.oak.jcr.version.VersionImpl;

public class VersionManagerImpl
implements VersionManager {
    private final SessionContext sessionContext;
    private final VersionManagerDelegate versionManagerDelegate;

    public VersionManagerImpl(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        this.versionManagerDelegate = VersionManagerDelegate.create(sessionContext.getSessionDelegate());
    }

    public Node setActivity(Node activity) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-827: Activities not implemented.");
    }

    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-168: Restore of by label not implemented.");
    }

    public void restore(final String absPath, final Version version, final boolean removeExisting) throws RepositoryException {
        final SessionDelegate sessionDelegate = this.sessionContext.getSessionDelegate();
        sessionDelegate.perform(new SessionOperation<Void>("restore", true){

            @Override
            public Void perform() throws RepositoryException {
                String oakPath = VersionManagerImpl.this.getOakPathOrThrowNotFound(absPath);
                NodeDelegate nodeDelegate = sessionDelegate.getNode(oakPath);
                if (nodeDelegate != null) {
                    throw new VersionException("VersionManager.restore(String, Version, boolean) not allowed on existing nodes; use VersionManager.restore(Version, boolean) instead: " + absPath);
                }
                NodeDelegate parent = VersionManagerImpl.this.ensureParentExists(sessionDelegate, absPath);
                VersionManagerImpl.this.checkPendingChangesForRestore(sessionDelegate);
                VersionManagerImpl.this.checkNotLocked(parent.getPath());
                List existing = VersionManagerImpl.this.getExisting(version, Collections.emptySet());
                boolean success = false;
                try {
                    if (!existing.isEmpty()) {
                        if (removeExisting) {
                            VersionManagerImpl.this.removeExistingNodes(existing);
                        } else {
                            ArrayList<String> paths = new ArrayList<String>();
                            for (NodeDelegate nd : existing) {
                                paths.add(nd.getPath());
                            }
                            throw new ItemExistsException("Unable to restore with removeExisting=false. Existing nodes in workspace: " + paths);
                        }
                    }
                    VersionDelegate vd = VersionManagerImpl.this.versionManagerDelegate.getVersionByIdentifier(version.getIdentifier());
                    VersionManagerImpl.this.versionManagerDelegate.restore(parent, PathUtils.getName((String)oakPath), vd);
                    sessionDelegate.commit();
                    success = true;
                }
                catch (CommitFailedException e) {
                    throw e.asRepositoryException();
                }
                finally {
                    if (!success) {
                        sessionDelegate.refresh(false);
                    }
                }
                return null;
            }
        });
    }

    public void restore(String absPath, String versionName, boolean removeExisting) throws RepositoryException {
        VersionHistory history = this.getVersionHistory(absPath);
        this.restore(new Version[]{history.getVersion(versionName)}, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws RepositoryException {
        this.restore(new Version[]{version}, removeExisting);
    }

    public void restore(Version[] versions, final boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        if (versions.length > 1) {
            throw new UnsupportedRepositoryOperationException("OAK-168: Restore of multiple versions not implemented.");
        }
        final Version version = versions[0];
        VersionHistory history = (VersionHistory)version.getParent();
        final String versionableId = history.getVersionableIdentifier();
        if (history.getRootVersion().isSame((Item)version)) {
            throw new VersionException("Restore of root version not possible");
        }
        final SessionDelegate sessionDelegate = this.sessionContext.getSessionDelegate();
        sessionDelegate.perform(new SessionOperation<Void>("restore", true){

            @Override
            public Void perform() throws RepositoryException {
                VersionManagerImpl.this.checkPendingChangesForRestore(sessionDelegate);
                NodeDelegate n = sessionDelegate.getNodeByIdentifier(versionableId);
                if (n == null) {
                    throw new VersionException("Unable to restore version. No versionable node with identifier: " + versionableId);
                }
                VersionManagerImpl.this.checkNotLocked(n.getPath());
                List existing = VersionManagerImpl.this.getExisting(version, Collections.singleton(n.getPath()));
                boolean success = false;
                try {
                    if (!existing.isEmpty()) {
                        if (removeExisting) {
                            VersionManagerImpl.this.removeExistingNodes(existing);
                        } else {
                            ArrayList<String> paths = new ArrayList<String>();
                            for (NodeDelegate nd : existing) {
                                paths.add(nd.getPath());
                            }
                            throw new ItemExistsException("Unable to restore with removeExisting=false. Existing nodes in workspace: " + paths);
                        }
                    }
                    VersionDelegate vd = VersionManagerImpl.this.versionManagerDelegate.getVersionByIdentifier(version.getIdentifier());
                    VersionManagerImpl.this.versionManagerDelegate.restore(n.getParent(), n.getName(), vd);
                    sessionDelegate.commit();
                    success = true;
                }
                catch (CommitFailedException e) {
                    throw new RepositoryException((Throwable)e);
                }
                finally {
                    if (!success) {
                        sessionDelegate.refresh(false);
                    }
                }
                return null;
            }
        });
    }

    public void removeActivity(Node activityNode) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-827: Activities not implemented.");
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort, boolean isShallow) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-1402: Merge not implemented.");
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-1402: Merge not implemented.");
    }

    public NodeIterator merge(Node activityNode) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-1402: Merge not implemented.");
    }

    private String getOakPathOrThrowNotFound(String absPath) throws PathNotFoundException {
        return this.sessionContext.getOakPathOrThrowNotFound(absPath);
    }

    public boolean isCheckedOut(final String absPath) throws RepositoryException {
        final SessionDelegate sessionDelegate = this.sessionContext.getSessionDelegate();
        return sessionDelegate.perform(new SessionOperation<Boolean>("isCheckoutOut"){

            @Override
            public Boolean perform() throws RepositoryException {
                String oakPath = VersionManagerImpl.this.getOakPathOrThrowNotFound(absPath);
                NodeDelegate nodeDelegate = sessionDelegate.getNode(oakPath);
                if (nodeDelegate == null) {
                    throw new PathNotFoundException(absPath);
                }
                return VersionManagerImpl.this.versionManagerDelegate.isCheckedOut(nodeDelegate);
            }
        });
    }

    public VersionHistory getVersionHistory(final String absPath) throws RepositoryException {
        SessionDelegate sessionDelegate = this.sessionContext.getSessionDelegate();
        return sessionDelegate.perform(new SessionOperation<VersionHistory>("getVersionHistory"){

            @Override
            public VersionHistory perform() throws RepositoryException {
                return new VersionHistoryImpl(VersionManagerImpl.this.internalGetVersionHistory(absPath), VersionManagerImpl.this.sessionContext);
            }
        });
    }

    public Version getBaseVersion(final String absPath) throws RepositoryException {
        final SessionDelegate sessionDelegate = this.sessionContext.getSessionDelegate();
        return sessionDelegate.perform(new SessionOperation<Version>("getBaseVersion"){

            @Override
            public Version perform() throws RepositoryException {
                String oakPath = VersionManagerImpl.this.getOakPathOrThrowNotFound(absPath);
                NodeDelegate nodeDelegate = sessionDelegate.getNode(oakPath);
                if (nodeDelegate == null) {
                    throw new PathNotFoundException(absPath);
                }
                return new VersionImpl(VersionManagerImpl.this.versionManagerDelegate.getBaseVersion(nodeDelegate), VersionManagerImpl.this.sessionContext);
            }
        });
    }

    public Node getActivity() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-827: Activities not implemented.");
    }

    public void doneMerge(String absPath, Version version) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-1402: Merge not implemented.");
    }

    public Node createConfiguration(String absPath) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-1403: Configurations not implemented.");
    }

    public Node createActivity(String title) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-827: Activities not implemented.");
    }

    public Version checkpoint(String absPath) throws RepositoryException {
        Version v = this.checkin(absPath);
        this.checkout(absPath);
        return v;
    }

    public void checkout(final String absPath) throws RepositoryException {
        final SessionDelegate sessionDelegate = this.sessionContext.getSessionDelegate();
        sessionDelegate.perform(new SessionOperation<Void>("checkout", true){

            @Override
            public Void perform() throws RepositoryException {
                String oakPath = VersionManagerImpl.this.getOakPathOrThrowNotFound(absPath);
                NodeDelegate nodeDelegate = sessionDelegate.getNode(oakPath);
                if (nodeDelegate == null) {
                    throw new PathNotFoundException(absPath);
                }
                VersionManagerImpl.this.checkNotLocked(absPath);
                VersionManagerImpl.this.versionManagerDelegate.checkout(nodeDelegate);
                return null;
            }
        });
    }

    public Version checkin(final String absPath) throws RepositoryException {
        final SessionDelegate sessionDelegate = this.sessionContext.getSessionDelegate();
        return sessionDelegate.perform(new SessionOperation<Version>("checkin", true){

            @Override
            public Version perform() throws RepositoryException {
                String oakPath = VersionManagerImpl.this.getOakPathOrThrowNotFound(absPath);
                NodeDelegate nodeDelegate = sessionDelegate.getNode(oakPath);
                if (nodeDelegate == null) {
                    throw new PathNotFoundException(absPath);
                }
                return new VersionImpl(VersionManagerImpl.this.versionManagerDelegate.checkin(nodeDelegate), VersionManagerImpl.this.sessionContext);
            }
        });
    }

    public void cancelMerge(String absPath, Version version) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("OAK-1402: Merge not implemented.");
    }

    private void checkPendingChangesForRestore(SessionDelegate sessionDelegate) throws InvalidItemStateException {
        if (sessionDelegate.hasPendingChanges()) {
            throw new InvalidItemStateException("Unable to restore. Session has pending changes.");
        }
    }

    private void checkNotLocked(String absPath) throws RepositoryException {
        if (this.sessionContext.getWorkspace().getLockManager().isLocked(absPath)) {
            throw new LockException("Node at " + absPath + " is locked");
        }
    }

    @Nonnull
    private NodeDelegate ensureParentExists(@Nonnull SessionDelegate sessionDelegate, @Nonnull String absPath) throws PathNotFoundException {
        String oakParentPath = this.getOakPathOrThrowNotFound(PathUtils.getParentPath((String)((String)Preconditions.checkNotNull((Object)absPath))));
        NodeDelegate parent = ((SessionDelegate)Preconditions.checkNotNull((Object)sessionDelegate)).getNode(oakParentPath);
        if (parent == null) {
            throw new PathNotFoundException(PathUtils.getParentPath((String)absPath));
        }
        return parent;
    }

    private List<NodeDelegate> getExisting(@Nonnull Version version, @Nonnull Set<String> versionablePaths) throws RepositoryException {
        final ArrayList uuids = new ArrayList();
        version.getFrozenNode().accept((ItemVisitor)new TraversingItemVisitor.Default(){

            protected void entering(Node node, int level) throws RepositoryException {
                if (node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode")) {
                    String id = node.getProperty("{http://www.jcp.org/jcr/1.0}frozenUuid").getString();
                    if (id.length() > 0) {
                        uuids.add(id);
                    }
                } else if (node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}versionedChild")) {
                    Node history = node.getProperty("{http://www.jcp.org/jcr/1.0}childVersionHistory").getNode();
                    uuids.add(history.getProperty("{http://www.jcp.org/jcr/1.0}versionableUuid").getString());
                }
            }
        });
        SessionDelegate delegate = this.sessionContext.getSessionDelegate();
        if (uuids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NodeDelegate> existing = new ArrayList<NodeDelegate>();
        for (String uuid : uuids) {
            NodeDelegate node = delegate.getNodeByIdentifier(uuid);
            if (node == null) continue;
            boolean inSubGraph = false;
            for (String versionablePath : versionablePaths) {
                if (!node.getPath().startsWith(versionablePath)) continue;
                inSubGraph = true;
                break;
            }
            if (inSubGraph) continue;
            existing.add(node);
        }
        return existing;
    }

    private void removeExistingNodes(List<NodeDelegate> existing) throws RepositoryException {
        for (NodeDelegate nd : existing) {
            if (nd.remove()) continue;
            throw new RepositoryException("Unable to remove existing node: " + nd.getPath());
        }
    }

    @Nonnull
    private VersionHistoryDelegate internalGetVersionHistory(@Nonnull String absPathVersionable) throws RepositoryException, UnsupportedRepositoryOperationException {
        String oakPath;
        SessionDelegate sessionDelegate = this.sessionContext.getSessionDelegate();
        NodeDelegate nodeDelegate = sessionDelegate.getNode(oakPath = this.getOakPathOrThrowNotFound((String)Preconditions.checkNotNull((Object)absPathVersionable)));
        if (nodeDelegate == null) {
            throw new PathNotFoundException(absPathVersionable);
        }
        return this.versionManagerDelegate.getVersionHistory(nodeDelegate);
    }
}

