/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.storage;

import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.storage.TempFileStorageProvider;
import org.apache.james.mime4j.storage.ThresholdStorageProvider;

public class DefaultStorageProvider {
    public static final String DEFAULT_STORAGE_PROVIDER_PROPERTY = "org.apache.james.mime4j.defaultStorageProvider";
    private static volatile StorageProvider instance = null;

    private DefaultStorageProvider() {
    }

    public static StorageProvider getInstance() {
        return instance;
    }

    public static void setInstance(StorageProvider instance) {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        DefaultStorageProvider.instance = instance;
    }

    private static void initialize() {
        String clazz = System.getProperty(DEFAULT_STORAGE_PROVIDER_PROPERTY);
        try {
            if (clazz != null) {
                instance = (StorageProvider)Class.forName(clazz).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (instance == null) {
            TempFileStorageProvider backend = new TempFileStorageProvider();
            instance = new ThresholdStorageProvider(backend, 1024);
        }
    }

    static void reset() {
        instance = null;
        DefaultStorageProvider.initialize();
    }

    static {
        DefaultStorageProvider.initialize();
    }
}

