/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.security.SecureRandom;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.atmos.AtmosApiMetadata;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.BoundedSet;
import org.jclouds.atmos.domain.DirectoryEntry;
import org.jclouds.atmos.domain.FileType;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyAlreadyExistsException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;
import org.jclouds.rest.RestContext;
import org.jclouds.util.Predicates2;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true)
public class AtmosClientLiveTest
extends BaseBlobStoreIntegrationTest {
    private static final int INCONSISTENCY_WINDOW = 5000;
    private String containerPrefix = BaseBlobStoreIntegrationTest.CONTAINER_PREFIX + "live";
    URI container1;
    URI container2;
    String privateDirectory;
    String publicDirectory;

    public AtmosClientLiveTest() {
        this.provider = "atmos";
    }

    public AtmosClient getApi() {
        return (AtmosClient)((RestContext)((BlobStoreContext)this.view).unwrap(AtmosApiMetadata.CONTEXT_TOKEN)).getApi();
    }

    @Test
    public void testListDirectorys() throws Exception {
        BoundedSet response = this.getApi().listDirectories(new ListOptions[0]);
        assert (null != response);
    }

    @Test(timeOut=300000L)
    public void testCreateDirectory() throws Exception {
        boolean created = false;
        while (!created) {
            this.privateDirectory = this.containerPrefix + new SecureRandom().nextInt();
            try {
                created = this.getApi().createDirectory(this.privateDirectory, new PutOptions[0]) != null;
            }
            catch (UndeclaredThrowableException e) {
                HttpResponseException htpe = (HttpResponseException)e.getCause().getCause();
                if (htpe.getResponse().getStatusCode() == 409) continue;
                throw e;
            }
        }
        BoundedSet response = this.getApi().listDirectories(new ListOptions[0]);
        for (DirectoryEntry id : response) {
            BoundedSet r2 = this.getApi().listDirectory(id.getObjectName(), new ListOptions[0]);
            assert (r2 != null);
        }
        Assert.assertNull((Object)this.getApi().createDirectory(this.privateDirectory, new PutOptions[0]));
    }

    @Test(timeOut=300000L, dependsOnMethods={"testCreateDirectory"})
    public void testListOptions() throws Exception {
        this.createOrReplaceObject("object2", "here is my data!", "meta-value1");
        this.createOrReplaceObject("object3", "here is my data!", "meta-value1");
        this.createOrReplaceObject("object4", "here is my data!", "meta-value1");
        BoundedSet r2 = this.getApi().listDirectory(this.privateDirectory, new ListOptions[]{ListOptions.Builder.limit((int)1)});
        Assert.assertEquals((int)r2.size(), (int)1);
        assert (r2.getToken() != null);
        Assert.assertEquals((String)((DirectoryEntry)Iterables.getLast((Iterable)Sets.newTreeSet((Iterable)r2))).getObjectName(), (String)"object2");
        r2 = this.getApi().listDirectory(this.privateDirectory, new ListOptions[]{ListOptions.Builder.token((String)r2.getToken())});
        Assert.assertEquals((int)r2.size(), (int)2);
        assert (r2.getToken() == null);
        Assert.assertEquals((String)((DirectoryEntry)Iterables.getLast((Iterable)Sets.newTreeSet((Iterable)r2))).getObjectName(), (String)"object4");
    }

    @Test(timeOut=300000L, dependsOnMethods={"testListOptions"})
    public void testFileOperations() throws Exception {
        System.err.printf("creating%n", new Object[0]);
        this.createOrReplaceObject("object", "here is my data!", "meta-value1");
        this.assertEventuallyObjectMatches("object", "here is my data!", "meta-value1");
        this.assertEventuallyHeadMatches("object", "meta-value1");
        System.err.printf("overwriting%n", new Object[0]);
        this.createOrReplaceObject("object", "here is my data?", "meta-value?");
        this.assertEventuallyObjectMatches("object", "here is my data?", "meta-value?");
        Boolean[] arr$ = new Boolean[]{true, false};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            boolean stream = arr$[i$];
            for (int i = 0; i < 10; ++i) {
                System.err.printf("upload/delete/create attempt %d type %s%n", i + 1, stream ? "stream" : "string");
                this.createOrUpdateWithErrorLoop(stream, "there is my data", "2");
                this.deleteConfirmed(this.privateDirectory + "/object");
                this.createOrUpdateWithErrorLoop(stream, "where is my data", "3");
            }
        }
    }

    @Test(timeOut=300000L, dependsOnMethods={"testFileOperations"})
    public void testPutZeroLengthBlob() throws Exception {
        AtmosObject object = this.getApi().newObject();
        object.getContentMetadata().setName("object");
        byte[] payload = new byte[]{};
        object.setPayload(Payloads.newPayload((Object)payload));
        object.getContentMetadata().setContentLength(Long.valueOf(payload.length));
        this.replaceObject(object);
    }

    private void createOrUpdateWithErrorLoop(boolean stream, String data, String metadataValue) throws Exception {
        this.createOrReplaceObject("object", this.makeData(data, stream), metadataValue);
        this.assertEventuallyObjectMatches("object", data, metadataValue);
    }

    Object makeData(String in, boolean stream) {
        return stream ? Strings2.toInputStream((String)in) : in;
    }

    private void createOrReplaceObject(String name, Object data, String metadataValue) throws Exception {
        AtmosObject object = this.getApi().newObject();
        object.getContentMetadata().setName(name);
        object.setPayload(Payloads.newPayload((Object)data));
        object.getContentMetadata().setContentLength(Long.valueOf(16L));
        Payloads.calculateMD5((PayloadEnclosing)object);
        object.getContentMetadata().setContentType("text/plain");
        object.getUserMetadata().getMetadata().put("Metadata", metadataValue);
        this.replaceObject(object);
    }

    protected static void assertEventually(Runnable assertion) throws InterruptedException {
        long start = System.currentTimeMillis();
        AssertionError error = null;
        for (int i = 0; i < 30; ++i) {
            try {
                assertion.run();
                if (i > 0) {
                    System.err.printf("%d attempts and %dms asserting %s%n", i + 1, System.currentTimeMillis() - start, assertion.getClass().getSimpleName());
                }
                return;
            }
            catch (AssertionError e) {
                error = e;
                Thread.sleep(166L);
                continue;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    protected void assertEventuallyObjectMatches(String name, String compare, String metadataValue) throws InterruptedException {
        AtmosClientLiveTest.assertEventually(new ObjectMatches(this.getApi(), this.privateDirectory + "/" + name, metadataValue, compare));
    }

    protected void assertEventuallyHeadMatches(String name, String metadataValue) throws InterruptedException {
        AtmosClientLiveTest.assertEventually(new HeadMatches(this.getApi(), this.privateDirectory + "/" + name, metadataValue));
    }

    private static void verifyHeadObject(AtmosClient connection, String path, String metadataValue) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        AtmosObject getBlob = connection.headFile(path);
        Assert.assertEquals((String)Strings2.toString((InputSupplier)getBlob.getPayload()), (String)"");
        AtmosClientLiveTest.verifyMetadata(metadataValue, getBlob);
    }

    private static void verifyObject(AtmosClient connection, String path, String compare, String metadataValue) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        AtmosObject getBlob = connection.readFile(path, new GetOptions[0]);
        Assert.assertEquals((String)Strings2.toString((InputSupplier)getBlob.getPayload()), (String)compare);
        AtmosClientLiveTest.verifyMetadata(metadataValue, getBlob);
    }

    private static void verifyMetadata(String metadataValue, AtmosObject getBlob) {
        Assert.assertEquals((Object)getBlob.getContentMetadata().getContentLength(), (Object)16L);
        assert (getBlob.getContentMetadata().getContentType().startsWith("text/plain"));
        Assert.assertEquals((String)((String)getBlob.getUserMetadata().getMetadata().get("Metadata")), (String)metadataValue);
        SystemMetadata md = getBlob.getSystemMetadata();
        Assert.assertEquals((long)md.getSize(), (long)16L);
        assert (md.getGroupID() != null);
        Assert.assertEquals((int)md.getHardLinkCount(), (int)1);
        assert (md.getInceptionTime() != null);
        assert (md.getLastAccessTime() != null);
        assert (md.getLastMetadataModification() != null);
        assert (md.getLastUserDataModification() != null);
        assert (md.getObjectID() != null);
        Assert.assertEquals((String)md.getObjectName(), (String)"object");
        assert (md.getPolicyName() != null);
        Assert.assertEquals((Object)md.getType(), (Object)FileType.REGULAR);
        assert (md.getUserID() != null);
        try {
            Strings2.toStringAndClose((InputStream)URI.create("http://accesspoint.emccis.com/rest/objects/" + getBlob.getSystemMetadata().getObjectID()).toURL().openStream());
            Assert.fail((String)"shouldn't have worked, since it is private");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void replaceObject(AtmosObject object) throws Exception {
        this.alwaysDeleteFirstReplaceStrategy(object);
    }

    private void alwaysDeleteFirstReplaceStrategy(AtmosObject object) throws Exception {
        this.deleteConfirmed(this.privateDirectory + "/" + object.getContentMetadata().getName());
        long time = System.currentTimeMillis();
        try {
            this.getApi().createFile(this.privateDirectory, object, new PutOptions[0]);
            System.err.printf("%s %s; %dms%n", "created", object.getPayload() instanceof InputStreamPayload ? "stream" : "string", System.currentTimeMillis() - time);
        }
        catch (Exception e) {
            String message = Throwables.getRootCause((Throwable)e).getMessage();
            System.err.printf("failure %s %s; %dms: [%s]%n", "creating", object.getPayload() instanceof InputStreamPayload ? "stream" : "string", System.currentTimeMillis() - time, message);
            throw e;
        }
    }

    private void deleteConfirmed(String path) throws InterruptedException, ExecutionException, TimeoutException {
        long time = System.currentTimeMillis();
        this.deleteConsistencyAware(path);
        System.err.printf("confirmed deletion after %dms%n", System.currentTimeMillis() - time);
    }

    protected void deleteImmediateAndVerifyWithHead(String path) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.getApi().deletePath(path);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            // empty catch block
        }
        assert (!this.getApi().pathExists(path));
        System.err.printf("path %s doesn't exist%n", path);
        assert (!this.getApi().pathExists(path));
        System.err.printf("path %s doesn't exist%n", path);
    }

    protected void deleteConsistencyAware(String path) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this.getApi().deletePath(path);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            // empty catch block
        }
        Preconditions.checkState((boolean)Predicates2.retry((Predicate)new Predicate<String>(){

            public boolean apply(String in) {
                try {
                    return !AtmosClientLiveTest.this.getApi().pathExists(in);
                }
                catch (ContainerNotFoundException e) {
                    return true;
                }
            }
        }, (long)5000L).apply((Object)path), (String)"%s still exists after deleting!", (Object[])new Object[]{path});
    }

    protected void retryAndCheckSystemMetadataAndPutIfPresentReplaceStrategy(AtmosObject object) throws Exception {
        int failures = 0;
        while (true) {
            try {
                this.checkSystemMetadataAndPutIfPresentReplaceStrategy(object);
            }
            catch (ExecutionException e1) {
                if (!(e1.getCause() instanceof KeyAlreadyExistsException)) {
                    throw e1;
                }
                ++failures;
                continue;
            }
            break;
        }
        if (failures > 0) {
            System.err.printf("%d failures create/replacing %s%n", failures, object.getPayload() instanceof InputStreamPayload ? "stream" : "string");
        }
    }

    private void checkSystemMetadataAndPutIfPresentReplaceStrategy(AtmosObject object) throws Exception {
        long time = System.currentTimeMillis();
        boolean update = true;
        try {
            this.getApi().getSystemMetadata(this.privateDirectory + "/object");
        }
        catch (KeyNotFoundException ex) {
            update = false;
        }
        try {
            if (update) {
                this.getApi().updateFile(this.privateDirectory, object, new PutOptions[0]);
            } else {
                this.getApi().createFile(this.privateDirectory, object, new PutOptions[0]);
            }
            System.err.printf("%s %s; %dms%n", update ? "updated" : "created", object.getPayload() instanceof InputStreamPayload ? "stream" : "string", System.currentTimeMillis() - time);
        }
        catch (Exception e) {
            String message = Throwables.getRootCause((Throwable)e).getMessage();
            System.err.printf("failure %s %s; %dms: [%s]%n", update ? "updating" : "creating", object.getPayload() instanceof InputStreamPayload ? "stream" : "string", System.currentTimeMillis() - time, message);
            throw e;
        }
    }

    private static final class ObjectMatches
    implements Runnable {
        private final AtmosClient connection;
        private final String name;
        private final String metadataValue;
        private final String compare;

        private ObjectMatches(AtmosClient connection, String name, String metadataValue, String compare) {
            this.connection = connection;
            this.name = name;
            this.metadataValue = metadataValue;
            this.compare = compare;
        }

        @Override
        public void run() {
            try {
                AtmosClientLiveTest.verifyObject(this.connection, this.name, this.compare, this.metadataValue);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static final class HeadMatches
    implements Runnable {
        private final AtmosClient connection;
        private final String name;
        private final String metadataValue;

        private HeadMatches(AtmosClient connection, String name, String metadataValue) {
            this.connection = connection;
            this.name = name;
            this.metadataValue = metadataValue;
        }

        @Override
        public void run() {
            try {
                AtmosClientLiveTest.verifyHeadObject(this.connection, this.name, this.metadataValue);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

