/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.binders;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.jclouds.atmos.binders.BindMetadataToHeaders;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.StringPayload;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindMetadataToHeadersTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    BindMetadataToHeaders binder = (BindMetadataToHeaders)this.injector.getInstance(BindMetadataToHeaders.class);

    public void testGood() {
        AtmosObject object = ((AtmosObject.Factory)this.injector.getInstance(AtmosObject.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        object.setPayload((Payload)payload);
        object.getUserMetadata().getListableMetadata().put("apple", "bear");
        object.getUserMetadata().getListableMetadata().put("sushi", "king");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)object);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("x-emc-listable-meta"), (String)"apple=bear,sushi=king");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeAtmosObject() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullPayloadIsBad() {
        AtmosObject object = ((AtmosObject.Factory)this.injector.getInstance(AtmosObject.Factory.class)).create(null);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)object);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullContentLengthIllegal() {
        AtmosObject object = ((AtmosObject.Factory)this.injector.getInstance(AtmosObject.Factory.class)).create(null);
        StringPayload payload = Payloads.newStringPayload((String)"");
        payload.getContentMetadata().setContentLength(null);
        object.setPayload((Payload)payload);
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)object);
    }
}

