/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.binders;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.jclouds.atmos.binders.BindUserMetadataToHeaders;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindUserMetadataToHeadersTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    BindUserMetadataToHeaders binder = (BindUserMetadataToHeaders)this.injector.getInstance(BindUserMetadataToHeaders.class);

    public void testMeta() {
        UserMetadata metadata = new UserMetadata();
        metadata.getMetadata().put("apple", "bear");
        metadata.getMetadata().put("sushi", "king");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)metadata);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("x-emc-meta"), (String)"apple=bear,sushi=king");
    }

    public void testListableMeta() {
        UserMetadata metadata = new UserMetadata();
        metadata.getListableMetadata().put("apple", "bear");
        metadata.getListableMetadata().put("sushi", "king");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)metadata);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("x-emc-listable-meta"), (String)"apple=bear,sushi=king");
    }

    public void testTags() {
        UserMetadata tagsdata = new UserMetadata();
        tagsdata.getTags().add("apple");
        tagsdata.getTags().add("sushi");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)tagsdata);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("x-emc-tags"), (String)"apple,sushi");
    }

    public void testListableTags() {
        UserMetadata tagsdata = new UserMetadata();
        tagsdata.getListableTags().add("apple");
        tagsdata.getListableTags().add("sushi");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)tagsdata);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("x-emc-listable-tags"), (String)"apple,sushi");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeUserMetadata() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

