/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore;

import com.google.common.base.Supplier;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Date;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.atmos.AtmosApiMetadata;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.config.AtmosRestClientModule;
import org.jclouds.atmos.filters.SignRequest;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AtmosBlobRequestSignerTest")
public class AtmosBlobRequestSignerTest
extends BaseAsyncClientTest<AtmosAsyncClient> {
    private BlobRequestSigner signer;
    private Blob.Factory blobFactory;

    public AtmosBlobRequestSignerTest() {
        this.credential = "aaaabbbb";
    }

    public void testSignGetBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signGetBlob("container", "name");
        this.assertRequestLineEquals(request, "GET https://accesspoint.atmosonline.com/rest/namespace/container/name HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Accept: */*\nDate: Thu, 05 Jun 2008 16:38:19 GMT\nx-emc-signature: DHDKwV6IPsJJvtrI9ktTiKq9us4=\nx-emc-uid: identity\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignRemoveBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signRemoveBlob("container", "name");
        this.assertRequestLineEquals(request, "DELETE https://accesspoint.atmosonline.com/rest/namespace/container/name HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Accept: */*\nDate: Thu, 05 Jun 2008 16:38:19 GMT\nx-emc-signature: cPnxwSdWfIjChx8sox+43U9oo20=\nx-emc-uid: identity\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignPutBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Blob blob = this.blobFactory.create(null);
        blob.getMetadata().setName("name");
        blob.setPayload("");
        blob.getPayload().getContentMetadata().setContentLength(Long.valueOf(2L));
        blob.getPayload().getContentMetadata().setContentMD5(new byte[]{0, 2, 4, 8});
        blob.getPayload().getContentMetadata().setContentType("text/plain");
        blob.getPayload().getContentMetadata().setExpires(new Date(1000L));
        HttpRequest request = this.signer.signPutBlob("container", blob);
        this.assertRequestLineEquals(request, "POST https://accesspoint.atmosonline.com/rest/namespace/container/name HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Accept: */*\nDate: Thu, 05 Jun 2008 16:38:19 GMT\nExpect: 100-continue\nx-emc-signature: DTzbKA9a0TAawWFEbC4D76wTq3A=\nx-emc-uid: identity\nx-emc-wschecksum: MD5/0/00020408\n");
        this.assertContentHeadersEqual(request, "text/plain", null, null, null, 2L, new byte[]{0, 2, 4, 8}, new Date(1000L));
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    @BeforeClass
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.blobFactory = (Blob.Factory)this.injector.getInstance(Blob.Factory.class);
        this.signer = (BlobRequestSigner)this.injector.getInstance(BlobRequestSigner.class);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SignRequest.class);
    }

    protected Module createModule() {
        return new TestAtmosRestClientModule();
    }

    public ApiMetadata createApiMetadata() {
        return new AtmosApiMetadata();
    }

    @ConfiguresRestClient
    private static final class TestAtmosRestClientModule
    extends AtmosRestClientModule {
        private TestAtmosRestClientModule() {
        }

        protected void configure() {
            super.configure();
        }

        protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
            return "Thu, 05 Jun 2008 16:38:19 GMT";
        }
    }
}

