/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.File;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.domain.SystemMetadata;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.atmos.functions.AtmosObjectName;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class AtmosObjectNameTest {
    AtmosObjectName fn = new AtmosObjectName();
    private static final AtmosObject.Factory BLOB_FACTORY = (AtmosObject.Factory)Guice.createInjector((Module[])new Module[0]).getInstance(AtmosObject.Factory.class);

    @Test
    public void testCorrectContentMetadataName() throws SecurityException, NoSuchMethodException {
        AtmosObject blob = BLOB_FACTORY.create(null);
        blob.getContentMetadata().setName("foo");
        Assert.assertEquals((String)this.fn.apply((Object)blob), (String)"foo");
    }

    @Test
    public void testCorrectSystemMetadataObjectName() throws SecurityException, NoSuchMethodException {
        AtmosObject blob = BLOB_FACTORY.create(new SystemMetadata(null, null, null, null, null, null, 0, null, "foo", null, 0L, null, null), new UserMetadata());
        Assert.assertEquals((String)this.fn.apply((Object)blob), (String)"foo");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeAtmosObject() {
        this.fn.apply((Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        this.fn.apply(null);
    }
}

