/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Guice;
import com.google.inject.Module;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.atmos.functions.ParseSystemMetadataFromHeadersTest;
import org.jclouds.atmos.functions.ParseUserMetadataFromHeadersTest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ParseObjectFromHeadersAndHttpContentTest")
public class ParseObjectFromHeadersAndHttpContentTest {
    static final HttpResponse RESPONSE = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("")).headers((Multimap)ImmutableMultimap.of((Object)"x-emc-tags", (Object)"tag1, tag2", (Object)"x-emc-listable-tags", (Object)"listabletag1, listabletag2", (Object)"x-emc-meta", (Object)"meta1=foo1, content-md5=1f3870be274f6c49b3e31a0c6728957f, atime=2009-10-12T16:09:42Z, mtime=2009-10-19T04:37:00Z, ctime=2009-10-19T04:37:00Z, itime=2009-10-12T16:09:42Z, type=directory, uid=root, gid=rootr, objectid=4980cdb2b010109b04a44f7bb83f5f04ad354c638ae5, objname=e913e09366364e9ba384b8fead643d43, size=4096, nlink=1, policyname=default", (Object)"x-emc-listable-meta", (Object)"listablemeta1=listablefoo1, listablemeta2=listablefoo2"))).build();
    public static final AtmosObject EXPECTED = ((AtmosObject.Factory)Guice.createInjector((Module[])new Module[0]).getInstance(AtmosObject.Factory.class)).create(ParseSystemMetadataFromHeadersTest.EXPECTED, ParseUserMetadataFromHeadersTest.EXPECTED);

    public void test() {
        ParseObjectFromHeadersAndHttpContent parser = (ParseObjectFromHeadersAndHttpContent)Guice.createInjector((Module[])new Module[0]).getInstance(ParseObjectFromHeadersAndHttpContent.class);
        AtmosObject data = parser.apply(RESPONSE);
        Assert.assertEquals((Object)data, (Object)EXPECTED);
    }

    static {
        EXPECTED.getContentMetadata().setName("e913e09366364e9ba384b8fead643d43");
        EXPECTED.setPayload(RESPONSE.getPayload());
    }
}

