/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.atmos.options.ListOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListOptionsTest {
    public void testToken() {
        ListOptions options = new ListOptions().token("a");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"a"), (Collection)options.buildRequestHeaders().get((Object)"x-emc-token"));
    }

    public void testTokenStatic() {
        ListOptions options = ListOptions.Builder.token((String)"a");
        Assert.assertEquals((Collection)ImmutableList.of((Object)"a"), (Collection)options.buildRequestHeaders().get((Object)"x-emc-token"));
    }

    public void testLimit() {
        int limit = 1;
        ListOptions options = new ListOptions().limit(limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildRequestHeaders().get((Object)"x-emc-limit"));
    }

    public void testLimitStatic() {
        int limit = 1;
        ListOptions options = ListOptions.Builder.limit((int)limit);
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildRequestHeaders().get((Object)"x-emc-limit"));
    }

    public void testNoMeta() {
        ListOptions options = new ListOptions();
        assert (!options.metaIncluded());
    }

    public void testMeta() {
        ListOptions options = new ListOptions().includeMeta();
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildRequestHeaders().get((Object)"x-emc-include-meta"));
        assert (options.metaIncluded());
    }

    public void testMetaStatic() {
        ListOptions options = ListOptions.Builder.includeMeta();
        Assert.assertEquals((Collection)ImmutableList.of((Object)"1"), (Collection)options.buildRequestHeaders().get((Object)"x-emc-include-meta"));
        assert (options.metaIncluded());
    }
}

