/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.atmos.AtmosAsyncClient;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.domain.AtmosObject;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;

@Singleton
public class AtmosBlobRequestSigner
implements BlobRequestSigner {
    private final Function<Invocation, HttpRequest> processor;
    private final BlobToObject blobToObject;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Invokable<?, ?> getMethod;
    private final Invokable<?, ?> deleteMethod;
    private final Invokable<?, ?> createMethod;

    @Inject
    public AtmosBlobRequestSigner(Function<Invocation, HttpRequest> processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2ObjectGetOptions) throws SecurityException, NoSuchMethodException {
        this.processor = (Function)Preconditions.checkNotNull(processor, (Object)"processor");
        this.blobToObject = (BlobToObject)Preconditions.checkNotNull((Object)blobToObject, (Object)"blobToObject");
        this.blob2ObjectGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2ObjectGetOptions, (Object)"blob2ObjectGetOptions");
        this.getMethod = Reflection2.method(AtmosAsyncClient.class, (String)"readFile", (Class[])new Class[]{String.class, GetOptions[].class});
        this.deleteMethod = Reflection2.method(AtmosAsyncClient.class, (String)"deletePath", (Class[])new Class[]{String.class});
        this.createMethod = Reflection2.method(AtmosAsyncClient.class, (String)"createFile", (Class[])new Class[]{String.class, AtmosObject.class, PutOptions[].class});
    }

    public HttpRequest signGetBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.getMethod, (List)ImmutableList.of((Object)this.getPath(container, name))))));
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.createMethod, (List)ImmutableList.of((Object)container, (Object)this.blobToObject.apply(blob))))));
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        throw new UnsupportedOperationException();
    }

    public HttpRequest signRemoveBlob(String container, String name) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.deleteMethod, (List)ImmutableList.of((Object)this.getPath(container, name))))));
    }

    private String getPath(String container, String name) {
        return (String)Preconditions.checkNotNull((Object)container, (Object)"container") + "/" + (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)((HttpRequest)this.processor.apply((Object)Invocation.create(this.getMethod, (List)ImmutableList.of((Object)this.getPath(container, name), (Object)this.blob2ObjectGetOptions.apply((org.jclouds.blobstore.options.GetOptions)Preconditions.checkNotNull((Object)options, (Object)"options")))))));
    }
}

