/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.suppliers;

import java.io.InputStream;
import java.net.URI;
import org.jclouds.byon.suppliers.SupplyFromProviderURIOrNodesProperty;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SupplyFromProviderURIOrNodesPropertyTest {
    @Test
    public void testFromURI() throws Exception {
        String path = this.getClass().getResource("/test1.yaml").getPath();
        SupplyFromProviderURIOrNodesProperty supplier = new SupplyFromProviderURIOrNodesProperty(URI.create("file://" + path));
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)supplier.get()), (String)Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test1.yaml")));
    }

    @Test
    public void testFromURIClasspath() throws Exception {
        SupplyFromProviderURIOrNodesProperty supplier = new SupplyFromProviderURIOrNodesProperty(URI.create("classpath:///test1.yaml"));
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)supplier.get()), (String)Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test1.yaml")));
    }

    @Test
    public void testFromProperty() throws Exception {
        SupplyFromProviderURIOrNodesProperty supplier = new SupplyFromProviderURIOrNodesProperty(URI.create("file://bar"));
        supplier.nodes = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test1.yaml"));
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)supplier.get()), (String)Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test1.yaml")));
    }

    @Test
    public void testSupplyMultipleTimes() throws Exception {
        String path = this.getClass().getResource("/test1.yaml").getPath();
        SupplyFromProviderURIOrNodesProperty supplier = new SupplyFromProviderURIOrNodesProperty(URI.create("file://" + path));
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)supplier.get()), (String)Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/test1.yaml")));
        }
    }
}

