/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles;

import java.net.URI;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.cloudfiles.CloudFilesClient;
import org.jclouds.cloudfiles.domain.ContainerCDNMetadata;
import org.jclouds.cloudfiles.internal.BaseCloudFilesRestClientExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudFilesClientExpectTest")
public class CloudFilesClientExpectTest
extends BaseCloudFilesRestClientExpectTest {
    @Test
    public void testDeleteContainerReturnsTrueOn200And404() {
        HttpRequest deleteContainer = ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse containerDeleted = HttpResponse.builder().statusCode(204).message("HTTP/1.1 204 No Content").build();
        CloudFilesClient clientWhenContainerExists = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, deleteContainer, containerDeleted);
        assert (clientWhenContainerExists.deleteContainerIfEmpty("container"));
        HttpResponse containerNotFound = HttpResponse.builder().statusCode(404).message("HTTP/1.1 404 Not Found").build();
        CloudFilesClient clientWhenContainerDoesntExist = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, deleteContainer, containerNotFound);
        assert (clientWhenContainerDoesntExist.deleteContainerIfEmpty("container"));
    }

    @Test
    public void testGetCDNMetadataWhenResponseIs2xxReturnsContainerCDNMetadata() {
        HttpRequest cdnContainerRequest = ((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint("https://cdn3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse cdnContainerResponse = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().addHeader("X-CDN-Enabled", new String[]{"True"})).addHeader("X-Log-Retention", new String[]{"True"})).addHeader("X-TTL", new String[]{"259200"})).addHeader("X-CDN-URI", new String[]{"http://546406d62bf471d7435d-36c33e76d676c80251b3c13ecb603b67.r19.cf1.rackcdn.com"})).addHeader("X-Cdn-Ssl-Uri", new String[]{"https://e9f6fe92d217dc013369-36c33e76d676c80251b3c13ecb603b67.ssl.cf1.rackcdn.com"})).addHeader("X-Cdn-Streaming-Uri", new String[]{"http://0e79346bc0a2564dcc5e-36c33e76d676c80251b3c13ecb603b67.r19.stream.cf1.rackcdn.com"})).statusCode(204).build();
        CloudFilesClient cdnContainerClient = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, cdnContainerRequest, cdnContainerResponse);
        ContainerCDNMetadata containerCDNMetadata = cdnContainerClient.getCDNMetadata("container");
        Assert.assertTrue((boolean)containerCDNMetadata.isCDNEnabled());
        Assert.assertTrue((boolean)containerCDNMetadata.isLogRetention());
        Assert.assertEquals((long)containerCDNMetadata.getTTL(), (long)259200L);
        Assert.assertEquals((String)containerCDNMetadata.getCDNUri().toString(), (String)"http://546406d62bf471d7435d-36c33e76d676c80251b3c13ecb603b67.r19.cf1.rackcdn.com");
        Assert.assertEquals((String)containerCDNMetadata.getCDNSslUri().toString(), (String)"https://e9f6fe92d217dc013369-36c33e76d676c80251b3c13ecb603b67.ssl.cf1.rackcdn.com");
        Assert.assertEquals((String)containerCDNMetadata.getCDNStreamingUri().toString(), (String)"http://0e79346bc0a2564dcc5e-36c33e76d676c80251b3c13ecb603b67.r19.stream.cf1.rackcdn.com");
    }

    @Test
    public void testGetCDNMetadataWhenResponseIs404ReturnsNull() {
        HttpRequest cdnContainerRequest = ((HttpRequest.Builder)HttpRequest.builder().method("HEAD").endpoint("https://cdn3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse cdnContainerResponse = HttpResponse.builder().statusCode(404).build();
        CloudFilesClient cdnContainerClient = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, cdnContainerRequest, cdnContainerResponse);
        Assert.assertNull((Object)cdnContainerClient.getCDNMetadata("container"));
    }

    @Test
    public void testUpdateCDNMetadataWhenResponseIs2xxReturnsURI() {
        HttpRequest cdnContainerRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://cdn3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container").addHeader("X-TTL", new String[]{"259200"})).addHeader("X-Log-Retention", new String[]{"true"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse cdnContainerResponse = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().addHeader("X-CDN-Enabled", new String[]{"True"})).addHeader("X-Log-Retention", new String[]{"True"})).addHeader("X-TTL", new String[]{"259200"})).addHeader("X-CDN-URI", new String[]{"http://546406d62bf471d7435d-36c33e76d676c80251b3c13ecb603b67.r19.cf1.rackcdn.com"})).addHeader("X-Cdn-Ssl-Uri", new String[]{"https://e9f6fe92d217dc013369-36c33e76d676c80251b3c13ecb603b67.ssl.cf1.rackcdn.com"})).addHeader("X-Cdn-Streaming-Uri", new String[]{"http://0e79346bc0a2564dcc5e-36c33e76d676c80251b3c13ecb603b67.r19.stream.cf1.rackcdn.com"})).statusCode(204).build();
        CloudFilesClient cdnContainerClient = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, cdnContainerRequest, cdnContainerResponse);
        URI cdnURI = cdnContainerClient.updateCDN("container", 259200L, true);
        Assert.assertEquals((String)cdnURI.toString(), (String)"http://546406d62bf471d7435d-36c33e76d676c80251b3c13ecb603b67.r19.cf1.rackcdn.com");
    }

    @Test(expectedExceptions={ContainerNotFoundException.class})
    public void testUpdateCDNMetadataWhenResponseIs404ThrowsException() {
        HttpRequest cdnContainerRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://cdn3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container").addHeader("X-TTL", new String[]{"259200"})).addHeader("X-Log-Retention", new String[]{"true"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse cdnContainerResponse = HttpResponse.builder().statusCode(404).build();
        CloudFilesClient cdnContainerClient = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, cdnContainerRequest, cdnContainerResponse);
        cdnContainerClient.updateCDN("container", 259200L, true);
    }

    @Test
    public void testPurgeCDNObjectWhenResponseIs2xxReturnsTrue() {
        HttpRequest cdnContainerRequest = ((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://cdn3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container/foo.txt").addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse cdnContainerResponse = HttpResponse.builder().statusCode(204).build();
        CloudFilesClient cdnContainerClient = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, cdnContainerRequest, cdnContainerResponse);
        Assert.assertTrue((boolean)cdnContainerClient.purgeCDNObject("container", "foo.txt"));
    }

    @Test
    public void testSetCDNStaticWebsiteIndexWhenResponseIs2xxReturnsTrue() {
        HttpRequest cdnContainerRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container").addHeader("X-Container-Meta-Web-Index", new String[]{"index.html"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse cdnContainerResponse = HttpResponse.builder().statusCode(204).build();
        CloudFilesClient cdnContainerClient = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, cdnContainerRequest, cdnContainerResponse);
        Assert.assertTrue((boolean)cdnContainerClient.setCDNStaticWebsiteIndex("container", "index.html"));
    }

    @Test(expectedExceptions={ContainerNotFoundException.class})
    public void testSetCDNStaticWebsiteIndexWhenResponseIs404ThrowsException() {
        HttpRequest cdnContainerRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container").addHeader("X-Container-Meta-Web-Index", new String[]{"index.html"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse cdnContainerResponse = HttpResponse.builder().statusCode(404).build();
        CloudFilesClient cdnContainerClient = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, cdnContainerRequest, cdnContainerResponse);
        cdnContainerClient.setCDNStaticWebsiteIndex("container", "index.html");
    }

    @Test
    public void testSetCDNStaticWebsiteErrorWhenResponseIs2xxReturnsTrue() {
        HttpRequest cdnContainerRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container").addHeader("X-Container-Meta-Web-Error", new String[]{"error.html"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse cdnContainerResponse = HttpResponse.builder().statusCode(204).build();
        CloudFilesClient cdnContainerClient = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, cdnContainerRequest, cdnContainerResponse);
        Assert.assertTrue((boolean)cdnContainerClient.setCDNStaticWebsiteError("container", "error.html"));
    }

    @Test(expectedExceptions={ContainerNotFoundException.class})
    public void testSetCDNStaticWebsiteErrorWhenResponseIs404ThrowsException() {
        HttpRequest cdnContainerRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://storage101.lon3.clouddrive.com/v1/MossoCloudFS_83a9d536-2e25-4166-bd3b-a503a934f953/container").addHeader("X-Container-Meta-Web-Error", new String[]{"error.html"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        HttpResponse cdnContainerResponse = HttpResponse.builder().statusCode(404).build();
        CloudFilesClient cdnContainerClient = (CloudFilesClient)this.requestsSendResponses(this.initialAuth, this.responseWithAuth, cdnContainerRequest, cdnContainerResponse);
        cdnContainerClient.setCDNStaticWebsiteError("container", "error.html");
    }
}

