/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.cloudfiles.CloudFilesApiMetadata;
import org.jclouds.cloudfiles.CloudFilesClient;
import org.jclouds.cloudfiles.domain.ContainerCDNMetadata;
import org.jclouds.cloudfiles.options.ListCdnContainerOptions;
import org.jclouds.openstack.swift.CommonSwiftClientLiveTest;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class CloudFilesClientLiveTest
extends CommonSwiftClientLiveTest<CloudFilesClient> {
    public CloudFilesClientLiveTest() {
        this.provider = "cloudfiles";
    }

    public CloudFilesClient getApi() {
        return (CloudFilesClient)((RestContext)((BlobStoreContext)this.view).unwrap(CloudFilesApiMetadata.CONTEXT_TOKEN)).getApi();
    }

    protected void testGetObjectContentType(SwiftObject getBlob) {
        Assert.assertEquals((String)getBlob.getInfo().getContentType(), (String)"application/x-www-form-urlencoded");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCDNOperations() throws Exception {
        long minimumTTL = 3600L;
        String containerNameWithCDN = this.getContainerName();
        String containerNameWithoutCDN = this.getContainerName();
        try {
            try {
                this.getApi().disableCDN(containerNameWithCDN);
                this.getApi().disableCDN(containerNameWithoutCDN);
            }
            catch (Exception e) {
                // empty catch block
            }
            ContainerCDNMetadata cdnMetadata = null;
            URI cdnUri = this.getApi().enableCDN(containerNameWithCDN);
            Assert.assertNotNull((Object)cdnUri);
            cdnMetadata = this.getApi().getCDNMetadata(containerNameWithCDN);
            Assert.assertTrue((boolean)cdnMetadata.isCDNEnabled());
            Assert.assertEquals((Object)cdnMetadata.getCDNUri(), (Object)cdnUri);
            this.getApi().setCDNStaticWebsiteIndex(containerNameWithCDN, "index.html");
            this.getApi().setCDNStaticWebsiteError(containerNameWithCDN, "error.html");
            ContainerMetadata containerMetadata = this.getApi().getContainerMetadata(containerNameWithCDN);
            Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("web-index")), (String)"index.html");
            Assert.assertEquals((String)((String)containerMetadata.getMetadata().get("web-error")), (String)"error.html");
            cdnMetadata = this.getApi().getCDNMetadata(containerNameWithoutCDN);
            assert (cdnMetadata == null || !cdnMetadata.isCDNEnabled()) : containerNameWithoutCDN + " should not have metadata";
            assert (this.getApi().getCDNMetadata("DoesNotExist") == null);
            Set cdnMetadataList = this.getApi().listCDNContainers(new ListCdnContainerOptions[0]);
            Assert.assertTrue((cdnMetadataList.size() >= 1 ? 1 : 0) != 0);
            cdnMetadata = this.getApi().getCDNMetadata(containerNameWithCDN);
            boolean cdnEnabled = cdnMetadata.isCDNEnabled();
            boolean logRetention = cdnMetadata.isLogRetention();
            long initialTTL = cdnMetadata.getTTL();
            URI cdnSslUri = cdnMetadata.getCDNSslUri();
            URI cdnStreamingUri = cdnMetadata.getCDNStreamingUri();
            Assert.assertTrue((boolean)cdnMetadataList.contains(new ContainerCDNMetadata(containerNameWithCDN, cdnEnabled, logRetention, initialTTL, cdnUri, cdnSslUri, cdnStreamingUri)));
            cdnMetadataList = this.getApi().listCDNContainers(new ListCdnContainerOptions[]{ListCdnContainerOptions.Builder.enabledOnly()});
            Assert.assertTrue((boolean)Iterables.all((Iterable)cdnMetadataList, (Predicate)new Predicate<ContainerCDNMetadata>(){

                public boolean apply(ContainerCDNMetadata cdnMetadata) {
                    return cdnMetadata.isCDNEnabled();
                }
            }));
            cdnMetadataList = this.getApi().listCDNContainers(new ListCdnContainerOptions[]{ListCdnContainerOptions.Builder.afterMarker((String)containerNameWithCDN.substring(0, containerNameWithCDN.length() - 1)).maxResults(1)});
            Assert.assertEquals((int)cdnMetadataList.size(), (int)1);
            long ttl = 4000L;
            this.getApi().enableCDN(containerNameWithCDN, ttl, true);
            cdnMetadata = this.getApi().getCDNMetadata(containerNameWithCDN);
            Assert.assertTrue((boolean)cdnMetadata.isCDNEnabled());
            Assert.assertEquals((long)cdnMetadata.getTTL(), (long)ttl);
            ttl = 3600L;
            this.getApi().updateCDN(containerNameWithCDN, 3600L, false);
            cdnMetadata = this.getApi().getCDNMetadata(containerNameWithCDN);
            Assert.assertTrue((boolean)cdnMetadata.isCDNEnabled());
            Assert.assertEquals((long)cdnMetadata.getTTL(), (long)3600L);
            this.getApi().updateCDN(containerNameWithCDN, 3599L, false);
            cdnMetadata = this.getApi().getCDNMetadata(containerNameWithCDN);
            Assert.assertEquals((long)cdnMetadata.getTTL(), (long)3599L);
            SwiftObject swiftObject = this.newSwiftObject("hello", "hello.txt");
            this.getApi().putObject(containerNameWithCDN, swiftObject);
            Assert.assertTrue((boolean)this.getApi().purgeCDNObject(containerNameWithCDN, swiftObject.getInfo().getName()));
            Assert.assertTrue((boolean)this.getApi().disableCDN(containerNameWithCDN));
            cdnMetadata = this.getApi().getCDNMetadata(containerNameWithCDN);
            Assert.assertEquals((boolean)cdnMetadata.isCDNEnabled(), (boolean)false);
        }
        finally {
            this.recycleContainer(containerNameWithCDN);
            this.recycleContainer(containerNameWithoutCDN);
        }
    }
}

