/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.blobstore.integration;

import java.io.IOException;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.openstack.swift.blobstore.integration.SwiftBlobIntegrationLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class CloudFilesBlobIntegrationLiveTest
extends SwiftBlobIntegrationLiveTest {
    public CloudFilesBlobIntegrationLiveTest() {
        this.provider = "cloudfiles";
    }

    protected void checkContentDisposition(Blob blob, String contentDisposition) {
        assert (blob.getPayload().getContentMetadata().getContentDisposition().startsWith(contentDisposition)) : blob.getPayload().getContentMetadata().getContentDisposition();
        assert (blob.getMetadata().getContentMetadata().getContentDisposition().startsWith(contentDisposition)) : blob.getMetadata().getContentMetadata().getContentDisposition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testChunksAreDeletedWhenMultipartBlobIsDeleted() throws IOException, InterruptedException {
        String containerName = this.getContainerName();
        try {
            BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
            long countBefore = blobStore.countBlobs(containerName);
            String blobName = "deleteme.txt";
            this.addMultipartBlobToContainer(containerName, blobName);
            blobStore.removeBlob(containerName, blobName);
            long countAfter = blobStore.countBlobs(containerName);
            Assert.assertEquals((long)countAfter, (long)countBefore);
        }
        finally {
            this.returnContainer(containerName);
        }
    }
}

