/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.cloudfiles.CDNManagement;
import org.jclouds.cloudfiles.binders.BindIterableToHeadersWithPurgeCDNObjectEmail;
import org.jclouds.cloudfiles.domain.ContainerCDNMetadata;
import org.jclouds.cloudfiles.functions.ParseCdnUriFromHeaders;
import org.jclouds.cloudfiles.functions.ParseContainerCDNMetadataFromHeaders;
import org.jclouds.cloudfiles.options.ListCdnContainerOptions;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.SwiftAsyncClient;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;

@Deprecated
@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=Storage.class)
public interface CloudFilesAsyncClient
extends SwiftAsyncClient {
    @Named(value="ListCDNEnabledContainers")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/")
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<? extends Set<ContainerCDNMetadata>> listCDNContainers(ListCdnContainerOptions ... var1);

    @Named(value="ListCDNEnabledContainerMetadata")
    @HEAD
    @ResponseParser(value=ParseContainerCDNMetadataFromHeaders.class)
    @Fallback(value=BlobStoreFallbacks.NullOnContainerNotFound.class)
    @Path(value="/{container}")
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<ContainerCDNMetadata> getCDNMetadata(@PathParam(value="container") String var1);

    @Named(value="CDNEnableContainer")
    @PUT
    @Path(value="/{container}")
    @Headers(keys={"X-CDN-Enabled"}, values={"True"})
    @ResponseParser(value=ParseCdnUriFromHeaders.class)
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<URI> enableCDN(@PathParam(value="container") String var1, @HeaderParam(value="X-TTL") long var2, @HeaderParam(value="X-Log-Retention") boolean var4);

    @Named(value="CDNEnableContainer")
    @PUT
    @Path(value="/{container}")
    @Headers(keys={"X-CDN-Enabled"}, values={"True"})
    @ResponseParser(value=ParseCdnUriFromHeaders.class)
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<URI> enableCDN(@PathParam(value="container") String var1, @HeaderParam(value="X-TTL") long var2);

    @Named(value="CDNEnableContainer")
    @PUT
    @Path(value="/{container}")
    @Headers(keys={"X-CDN-Enabled"}, values={"True"})
    @ResponseParser(value=ParseCdnUriFromHeaders.class)
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<URI> enableCDN(@PathParam(value="container") String var1);

    @Named(value="UpdateCDNEnabledContainerMetadata")
    @POST
    @Path(value="/{container}")
    @ResponseParser(value=ParseCdnUriFromHeaders.class)
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<URI> updateCDN(@PathParam(value="container") String var1, @HeaderParam(value="X-TTL") long var2, @HeaderParam(value="X-Log-Retention") boolean var4);

    @Named(value="UpdateCDNEnabledContainerMetadata")
    @POST
    @Path(value="/{container}")
    @ResponseParser(value=ParseCdnUriFromHeaders.class)
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<URI> updateCDN(@PathParam(value="container") String var1, @HeaderParam(value="X-Log-Retention") boolean var2);

    @Named(value="UpdateCDNEnabledContainerMetadata")
    @POST
    @Path(value="/{container}")
    @ResponseParser(value=ParseCdnUriFromHeaders.class)
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<URI> updateCDN(@PathParam(value="container") String var1, @HeaderParam(value="X-TTL") long var2);

    @Named(value="DisableCDNEnabledContainer")
    @POST
    @Path(value="/{container}")
    @Headers(keys={"X-CDN-Enabled"}, values={"False"})
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<Boolean> disableCDN(@PathParam(value="container") String var1);

    @Named(value="PurgeCDNEnabledObject")
    @DELETE
    @Path(value="/{container}/{object}")
    @Headers(keys={"X-Purge-Email"}, values={"{email}"})
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<Boolean> purgeCDNObject(@PathParam(value="container") String var1, @PathParam(value="object") String var2, @BinderParam(value=BindIterableToHeadersWithPurgeCDNObjectEmail.class) Iterable<String> var3);

    @Named(value="PurgeCDNEnabledObject")
    @DELETE
    @Path(value="/{container}/{object}")
    @Endpoint(value=CDNManagement.class)
    public ListenableFuture<Boolean> purgeCDNObject(@PathParam(value="container") String var1, @PathParam(value="object") String var2);

    @Named(value="UpdateCDNEnabledContainerMetadata")
    @POST
    @Path(value="/{container}")
    @Headers(keys={"X-Container-Meta-Web-Index"}, values={"{index}"})
    public ListenableFuture<Boolean> setCDNStaticWebsiteIndex(@PathParam(value="container") String var1, @PathParam(value="index") String var2);

    @Named(value="UpdateCDNEnabledContainerMetadata")
    @POST
    @Path(value="/{container}")
    @Headers(keys={"X-Container-Meta-Web-Error"}, values={"{error}"})
    public ListenableFuture<Boolean> setCDNStaticWebsiteError(@PathParam(value="container") String var1, @PathParam(value="error") String var2);
}

