/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Invokable;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import org.jclouds.Fallbacks;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.cloudservers.CloudServersApiMetadata;
import org.jclouds.cloudservers.CloudServersAsyncClient;
import org.jclouds.cloudservers.config.CloudServersRestClientModule;
import org.jclouds.cloudservers.domain.BackupSchedule;
import org.jclouds.cloudservers.domain.DailyBackup;
import org.jclouds.cloudservers.domain.RebootType;
import org.jclouds.cloudservers.domain.WeeklyBackup;
import org.jclouds.cloudservers.options.CreateServerOptions;
import org.jclouds.cloudservers.options.CreateSharedIpGroupOptions;
import org.jclouds.cloudservers.options.ListOptions;
import org.jclouds.cloudservers.options.RebuildServerOptions;
import org.jclouds.domain.Credentials;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.openstack.filters.AddTimestampQuery;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v1_1.config.AuthenticationServiceModule;
import org.jclouds.openstack.keystone.v1_1.domain.Auth;
import org.jclouds.openstack.keystone.v1_1.parse.ParseAuthTest;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="CloudServersAsyncClientTest")
public class CloudServersAsyncClientTest
extends BaseAsyncClientTest<CloudServersAsyncClient> {
    Date now = new Date(10000000L);
    protected String provider = "cloudservers";

    public void testCreateServer() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"createServer", (Class[])new Class[]{String.class, Integer.TYPE, Integer.TYPE, CreateServerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"ralphie", (Object)2, (Object)1));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateServerWithIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"createServer", (Class[])new Class[]{String.class, Integer.TYPE, Integer.TYPE, CreateServerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"ralphie", (Object)2, (Object)1, (Object)CreateServerOptions.Builder.withSharedIpGroup((int)2)));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1,\"sharedIpGroupId\":2}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateServerWithFile() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"createServer", (Class[])new Class[]{String.class, Integer.TYPE, Integer.TYPE, CreateServerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"ralphie", (Object)2, (Object)1, (Object)CreateServerOptions.Builder.withFile((String)"/etc/jclouds", (byte[])"foo".getBytes())));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1,\"personality\":[{\"path\":\"/etc/jclouds\",\"contents\":\"Zm9v\"}]}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateServerWithMetadata() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"createServer", (Class[])new Class[]{String.class, Integer.TYPE, Integer.TYPE, CreateServerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"ralphie", (Object)2, (Object)1, (Object)CreateServerOptions.Builder.withMetadata((Map)ImmutableMap.of((Object)"foo", (Object)"bar"))));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1,\"metadata\":{\"foo\":\"bar\"}}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateServerWithIpGroupAndSharedIp() throws IOException, SecurityException, NoSuchMethodException, UnknownHostException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"createServer", (Class[])new Class[]{String.class, Integer.TYPE, Integer.TYPE, CreateServerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"ralphie", (Object)2, (Object)1, (Object)CreateServerOptions.Builder.withSharedIpGroup((int)2).withSharedIp("127.0.0.1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"ralphie\",\"imageId\":2,\"flavorId\":1,\"sharedIpGroupId\":2,\"addresses\":{\"public\":[\"127.0.0.1\"]}}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteImage() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"deleteImage", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.FalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testLimits() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"getLimits", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/limits?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListServers() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listServers", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListServersOptions() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listServers", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.changesSince((Date)this.now).maxResults(1).startAt(2L)));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListServersDetail() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listServers", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.withDetails()));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/detail?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetServer() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"getServer", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListFlavors() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listFlavors", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/flavors?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListFlavorsOptions() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listFlavors", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.changesSince((Date)this.now).maxResults(1).startAt(2L)));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/flavors?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListFlavorsDetail() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listFlavors", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.withDetails()));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/flavors/detail?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListFlavorsDetailOptions() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listFlavors", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.withDetails().changesSince(this.now).maxResults(1).startAt(2L)));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/flavors/detail?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetFlavor() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"getFlavor", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/flavors/2?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListImages() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listImages", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListImagesDetail() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listImages", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.withDetails()));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/detail?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListImagesOptions() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listImages", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.changesSince((Date)this.now).maxResults(1).startAt(2L)));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListImagesDetailOptions() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listImages", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.withDetails().changesSince(this.now).maxResults(1).startAt(2L)));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/detail?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetImage() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"getImage", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/2?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteServer() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"deleteServer", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.FalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testShareIpNoConfig() throws IOException, SecurityException, NoSuchMethodException, UnknownHostException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"shareIp", (Class[])new Class[]{String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"127.0.0.1", (Object)2, (Object)3, (Object)false));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/ips/public/127.0.0.1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"shareIp\":{\"sharedIpGroupId\":3,\"configureServer\":false}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testShareIpConfig() throws IOException, SecurityException, NoSuchMethodException, UnknownHostException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"shareIp", (Class[])new Class[]{String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"127.0.0.1", (Object)2, (Object)3, (Object)true));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/ips/public/127.0.0.1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"shareIp\":{\"sharedIpGroupId\":3,\"configureServer\":true}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testUnshareIpNoConfig() throws IOException, SecurityException, NoSuchMethodException, UnknownHostException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"unshareIp", (Class[])new Class[]{String.class, Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"127.0.0.1", (Object)2, (Object)3, (Object)false));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/ips/public/127.0.0.1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testReplaceBackupSchedule() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"replaceBackupSchedule", (Class[])new Class[]{Integer.TYPE, BackupSchedule.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)BackupSchedule.builder().weekly(WeeklyBackup.MONDAY).daily(DailyBackup.H_0800_1000).enabled(true).build()));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/backup_schedule HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"backupSchedule\":{\"daily\":\"H_0800_1000\",\"enabled\":true,\"weekly\":\"MONDAY\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteBackupSchedule() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"deleteBackupSchedule", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/backup_schedule HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.FalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testChangeAdminPass() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"changeAdminPass", (Class[])new Class[]{Integer.TYPE, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)"foo"));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"adminPass\":\"foo\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testChangeServerName() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"renameServer", (Class[])new Class[]{Integer.TYPE, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)"foo"));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"server\":{\"name\":\"foo\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListSharedIpGroups() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listSharedIpGroups", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/shared_ip_groups?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListSharedIpGroupsOptions() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listSharedIpGroups", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.changesSince((Date)this.now).maxResults(1).startAt(2L)));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/shared_ip_groups?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListSharedIpGroupsDetail() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listSharedIpGroups", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.withDetails()));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/shared_ip_groups/detail?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListSharedIpGroupsDetailOptions() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listSharedIpGroups", (Class[])new Class[]{ListOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)ListOptions.Builder.withDetails().changesSince(this.now).maxResults(1).startAt(2L)));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/shared_ip_groups/detail?format=json&changes-since=10000&limit=1&offset=2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetSharedIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"getSharedIpGroup", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/shared_ip_groups/2?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateSharedIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"createSharedIpGroup", (Class[])new Class[]{String.class, CreateSharedIpGroupOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"ralphie"));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/shared_ip_groups?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"sharedIpGroup\":{\"name\":\"ralphie\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateSharedIpGroupWithIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"createSharedIpGroup", (Class[])new Class[]{String.class, CreateSharedIpGroupOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"ralphie", (Object)CreateSharedIpGroupOptions.Builder.withServer((int)2)));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/shared_ip_groups?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"sharedIpGroup\":{\"name\":\"ralphie\",\"server\":2}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteSharedIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"deleteSharedIpGroup", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://lon.servers.api.rackspacecloud.com/v1.0/10001786/shared_ip_groups/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnTrueIf2xx.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.FalseOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListAddresses() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"getAddresses", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/ips?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListPublicAddresses() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listPublicAddresses", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/ips/public?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListPrivateAddresses() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"listPrivateAddresses", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/ips/private?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListBackupSchedule() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"getBackupSchedule", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/backup_schedule?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateImageWithIpGroup() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"createImageFromServer", (Class[])new Class[]{String.class, Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"ralphie", (Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/json\n");
        this.assertPayloadEquals((HttpRequest)request, "{\"image\":{\"serverId\":2,\"name\":\"ralphie\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, UnwrapOnlyJsonValue.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRebuildServer() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"rebuildServer", (Class[])new Class[]{Integer.TYPE, RebuildServerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)3));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/3/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"rebuild\":{}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRebuildServerWithImage() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"rebuildServer", (Class[])new Class[]{Integer.TYPE, RebuildServerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)3, (Object)RebuildServerOptions.Builder.withImage((int)2)));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/3/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"rebuild\":{\"imageId\":2}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testReboot() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"rebootServer", (Class[])new Class[]{Integer.TYPE, RebootType.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)RebootType.HARD));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"reboot\":{\"type\":\"HARD\"}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testResize() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"resizeServer", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)3));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"resize\":{\"flavorId\":3}}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testConfirmResize() throws IOException, IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"confirmResizeServer", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"confirmResize\":null}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRevertResize() throws IOException, SecurityException, NoSuchMethodException {
        Invokable method = Reflection2.method(CloudServersAsyncClient.class, (String)"revertResizeServer", (Class[])new Class[]{Integer.TYPE});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/2/action?format=json HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, "{\"revertResize\":null}", "application/json", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)2);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), AuthenticateRequest.class);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(1)).getClass(), AddTimestampQuery.class);
    }

    protected Module createModule() {
        return new TestCloudServersRestClientModule();
    }

    protected ApiMetadata createApiMetadata() {
        return new CloudServersApiMetadata();
    }

    protected Properties setupProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.regions", "US");
        overrides.setProperty("jclouds.api-version", "1");
        overrides.setProperty(this.provider + ".endpoint", "https://auth");
        return overrides;
    }

    @ConfiguresRestClient
    protected static class TestCloudServersRestClientModule
    extends CloudServersRestClientModule {
        protected TestCloudServersRestClientModule() {
        }

        @Provides
        @Singleton
        AuthenticationServiceModule.GetAuth provideGetAuth() {
            return new AuthenticationServiceModule.GetAuth(null){

                public Auth load(Credentials in) {
                    return new ParseAuthTest().expected();
                }
            };
        }
    }
}

