/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute;

import com.google.inject.Module;
import java.io.IOException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.domain.LocationScope;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true, testName="CloudServersComputeServiceLiveTest")
public class CloudServersComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public CloudServersComputeServiceLiveTest() {
        this.provider = "cloudservers";
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    protected void checkNodes(Iterable<? extends NodeMetadata> nodes, String group, String task) throws IOException {
        super.checkNodes(nodes, group, task);
        for (NodeMetadata nodeMetadata : nodes) {
            Assert.assertEquals((Object)nodeMetadata.getLocation().getScope(), (Object)LocationScope.HOST);
        }
    }

    @Test(enabled=true, dependsOnMethods={"testReboot"}, expectedExceptions={UnsupportedOperationException.class})
    public void testSuspendResume() throws Exception {
        super.testSuspendResume();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testGetNodesWithDetails() throws Exception {
        super.testGetNodesWithDetails();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodes() throws Exception {
        super.testListNodes();
    }

    @Test(enabled=true, dependsOnMethods={"testSuspendResume"})
    public void testListNodesByIds() throws Exception {
        super.testListNodesByIds();
    }

    @Test(enabled=true, dependsOnMethods={"testListNodes", "testGetNodesWithDetails", "listNodesByIds"})
    public void testDestroyNodes() {
        super.testDestroyNodes();
    }
}

