/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import java.util.Map;
import java.util.concurrent.Future;
import org.jclouds.cloudservers.internal.BaseCloudServersComputeServiceExpectTest;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudServersImageExtensionExpectTest")
public class CloudServersImageExtensionExpectTest
extends BaseCloudServersComputeServiceExpectTest<ComputeService> {
    private HttpRequest getServerDetail;
    private HttpResponse getServerResponse;
    HttpRequest createImage;
    HttpResponse createImageResponse;
    private HttpRequest getImage;
    private HttpResponse getImageResponse;

    public CloudServersImageExtensionExpectTest() {
        this.getServerDetail = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://lon.servers.api.rackspacecloud.com/v1.0/10001786/servers/1234?format=json&now=1257695648897").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        this.getServerResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/test_get_server_detail.json"))).build();
        this.createImage = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images?format=json&now=1257695648897").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).payload(CloudServersImageExtensionExpectTest.payloadFromStringWithContentType((String)"{\"image\":{\"serverId\":1234,\"name\":\"test\"}}", (String)"application/json"))).build();
        this.createImageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(CloudServersImageExtensionExpectTest.payloadFromStringWithContentType((String)"{\"image\":{\"id\":2,\"serverId\":1234,\"name\":\"test\",\"status\":\"SAVING\"}}", (String)"application/json"))).build();
        this.getImage = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://lon.servers.api.rackspacecloud.com/v1.0/10001786/images/2?format=json&now=1257695648897").addHeader("Accept", new String[]{"application/json"})).addHeader("X-Auth-Token", new String[]{this.authToken})).build();
        this.getImageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/test_get_image_active.json"))).build();
    }

    public void testCreateImage() {
        ImmutableMap.Builder requestResponseMap = ImmutableMap.builder();
        requestResponseMap.put((Object)this.initialAuth, (Object)this.responseWithAuth);
        requestResponseMap.put((Object)this.getServerDetail, (Object)this.getServerResponse).build();
        requestResponseMap.put((Object)this.createImage, (Object)this.createImageResponse).build();
        requestResponseMap.put((Object)this.getImage, (Object)this.getImageResponse).build();
        ImageExtension apiThatCreatesImage = (ImageExtension)((ComputeService)this.requestsSendResponses((Map)requestResponseMap.build())).getImageExtension().get();
        ImageTemplate newImageTemplate = apiThatCreatesImage.buildImageTemplateFromNode("test", "1234");
        Image image = (Image)Futures.getUnchecked((Future)apiThatCreatesImage.createImage(newImageTemplate));
        Assert.assertEquals((String)image.getId(), (String)"2");
    }

    public ComputeService apply(ComputeServiceContext input) {
        return input.getComputeService();
    }
}

