/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jclouds.cloudsigma.compute.functions.ParseOsFamilyVersion64BitFromImageName;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ParseOsFamilyVersion64BitFromImageNameTest {
    Json json = new GsonWrapper(new Gson());
    ParseOsFamilyVersion64BitFromImageName parser = new ParseOsFamilyVersion64BitFromImageName(new BaseComputeServiceContextModule(){}.provideOsVersionMap(new ComputeServiceConstants.ReferenceData(), (Json)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(Json.class)));

    @DataProvider(name="data")
    public Object[][] createData() throws IOException {
        InputStream is = ParseOsFamilyVersion64BitFromImageNameTest.class.getResourceAsStream("/osmatches.json");
        Map values = (Map)this.json.fromJson(Strings2.toStringAndClose((InputStream)is), new TypeLiteral<Map<String, OsFamilyVersion64Bit>>(){}.getType());
        return (Object[][])Lists.newArrayList((Iterable)Iterables.transform(values.entrySet(), (Function)new Function<Map.Entry<String, OsFamilyVersion64Bit>, Object[]>(){

            public Object[] apply(Map.Entry<String, OsFamilyVersion64Bit> input) {
                return new Object[]{input.getKey(), input.getValue()};
            }
        })).toArray((T[])new Object[0][]);
    }

    @Test(dataProvider="data")
    public void test(String input, OsFamilyVersion64Bit expected) {
        Assert.assertEquals((Object)this.parser.apply(input), (Object)expected);
    }
}

