/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.options;

import org.jclouds.cloudsigma.domain.AffinityType;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CloneDriveOptionsTest {
    @Test
    public void testNullSize() {
        CloneDriveOptions options = new CloneDriveOptions();
        Assert.assertNull(options.getOptions().get("size"));
    }

    @Test
    public void testSize() {
        CloneDriveOptions options = new CloneDriveOptions().size(1024L);
        Assert.assertEquals((String)((String)options.getOptions().get("size")), (String)"1024");
    }

    @Test
    public void testSizeStatic() {
        CloneDriveOptions options = CloneDriveOptions.Builder.size((long)1024L);
        Assert.assertEquals((String)((String)options.getOptions().get("size")), (String)"1024");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSizeNegative() {
        CloneDriveOptions.Builder.size((long)-1L);
    }

    @Test
    public void testNullTags() {
        CloneDriveOptions options = new CloneDriveOptions();
        Assert.assertNull(options.getOptions().get("tags"));
    }

    @Test
    public void testTags() {
        CloneDriveOptions options = new CloneDriveOptions().tags(new String[]{"foo", "bar", "baz"});
        Assert.assertEquals((String)((String)options.getOptions().get("tags")), (String)"foo bar baz");
    }

    @Test
    public void testTagsStatic() {
        CloneDriveOptions options = CloneDriveOptions.Builder.tags((String[])new String[]{"foo", "bar", "baz"});
        Assert.assertEquals((String)((String)options.getOptions().get("tags")), (String)"foo bar baz");
    }

    @Test
    public void testHddAffinity() {
        CloneDriveOptions options = new CloneDriveOptions().affinity(AffinityType.HDD);
        Assert.assertNull(options.getOptions().get("tags"));
    }

    @Test
    public void testHddAffinityStatic() {
        CloneDriveOptions options = CloneDriveOptions.Builder.affinity((AffinityType)AffinityType.HDD);
        Assert.assertNull(options.getOptions().get("tags"));
    }

    @Test
    public void testSsdAffinity() {
        CloneDriveOptions options = new CloneDriveOptions().affinity(AffinityType.SSD);
        Assert.assertEquals((String)((String)options.getOptions().get("tags")), (String)"affinity:ssd");
    }

    @Test
    public void testSsdAffinityStatic() {
        CloneDriveOptions options = CloneDriveOptions.Builder.affinity((AffinityType)AffinityType.SSD);
        Assert.assertEquals((String)((String)options.getOptions().get("tags")), (String)"affinity:ssd");
    }

    @Test
    public void testHddAffinityBeforeTags() {
        CloneDriveOptions options = new CloneDriveOptions().affinity(AffinityType.HDD);
        options.tags(new String[]{"foo", "bar", "baz"});
        Assert.assertEquals((String)((String)options.getOptions().get("tags")), (String)"foo bar baz");
    }

    @Test
    public void testSsdAffinityBeforeTags() {
        CloneDriveOptions options = new CloneDriveOptions().affinity(AffinityType.SSD);
        options.tags(new String[]{"foo", "bar", "baz"});
        Assert.assertEquals((String)((String)options.getOptions().get("tags")), (String)"foo bar baz affinity:ssd");
    }

    @Test
    public void testHddAffinityAfterTags() {
        CloneDriveOptions options = new CloneDriveOptions().tags(new String[]{"foo", "bar", "baz"});
        options.affinity(AffinityType.HDD);
        Assert.assertEquals((String)((String)options.getOptions().get("tags")), (String)"foo bar baz");
    }

    @Test
    public void testSsdAffinityAfterTags() {
        CloneDriveOptions options = new CloneDriveOptions().tags(new String[]{"foo", "bar", "baz"});
        options.affinity(AffinityType.SSD);
        Assert.assertEquals((String)((String)options.getOptions().get("tags")), (String)"foo bar baz affinity:ssd");
    }
}

