/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudsigma.domain.ServerInfo;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToListOfMaps;
import org.jclouds.cloudsigma.functions.MapToServerInfo;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet
implements Function<HttpResponse, Set<ServerInfo>> {
    private final ReturnStringIf2xx returnStringIf200;
    private final ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter;
    private final MapToServerInfo mapToServer;

    @Inject
    ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet(ReturnStringIf2xx returnStringIf200, ListOfKeyValuesDelimitedByBlankLinesToListOfMaps mapConverter, MapToServerInfo mapToServer) {
        this.returnStringIf200 = returnStringIf200;
        this.mapConverter = mapConverter;
        this.mapToServer = mapToServer;
    }

    public Set<ServerInfo> apply(HttpResponse response) {
        String text = this.returnStringIf200.apply(response);
        if (text == null || text.trim().equals("")) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.mapConverter.apply(text), (Function)this.mapToServer));
    }
}

