/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import org.jclouds.cloudstack.domain.Account;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.features.GlobalAccountClientLiveTest;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DomainAccountClientLiveTest")
public class DomainAccountClientLiveTest
extends BaseCloudStackClientLiveTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableDisableAccount() {
        this.skipIfNotGlobalAdmin();
        Account testAccount = null;
        try {
            testAccount = GlobalAccountClientLiveTest.createTestAccount(this.globalAdminClient, this.prefix);
            AsyncCreateResponse response = this.domainAdminClient.getAccountClient().disableAccount(testAccount.getName(), testAccount.getDomainId(), false);
            Assert.assertNotNull((Object)response);
            Assert.assertTrue((boolean)this.adminJobComplete.apply((Object)response.getJobId()));
            AsyncJob job = this.domainAdminClient.getAsyncJobClient().getAsyncJob(response.getJobId());
            Assert.assertEquals((Object)((Account)job.getResult()).getState(), (Object)Account.State.DISABLED);
            Account updated = this.domainAdminClient.getAccountClient().enableAccount(testAccount.getName(), testAccount.getDomainId());
            Assert.assertNotNull((Object)updated);
            Assert.assertEquals((Object)updated.getState(), (Object)Account.State.ENABLED);
        }
        finally {
            if (testAccount != null) {
                this.globalAdminClient.getAccountClient().deleteAccount(testAccount.getId());
            }
        }
    }
}

