/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.cloudstack.domain.IPForwardingRule;
import org.jclouds.cloudstack.internal.BaseCloudStackClientLiveTest;
import org.jclouds.cloudstack.options.ListIPForwardingRulesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="NATClientLiveTest")
public class NATClientLiveTest
extends BaseCloudStackClientLiveTest {
    @Test(enabled=false)
    public void testListIPForwardingRules() throws Exception {
        Set response = this.client.getNATClient().listIPForwardingRules(new ListIPForwardingRulesOptions[0]);
        assert (null != response);
        Assert.assertTrue((response.size() >= 0 ? 1 : 0) != 0);
        for (IPForwardingRule rule : response) {
            IPForwardingRule newDetails = (IPForwardingRule)Iterables.getOnlyElement((Iterable)this.client.getNATClient().listIPForwardingRules(new ListIPForwardingRulesOptions[]{ListIPForwardingRulesOptions.Builder.id((String)rule.getId())}));
            Assert.assertEquals((String)rule.getId(), (String)newDetails.getId());
            this.checkRule(rule);
        }
    }

    protected void checkRule(IPForwardingRule rule) {
        Assert.assertEquals((String)rule.getId(), (String)this.client.getNATClient().getIPForwardingRule(rule.getId()).getId());
        assert (rule.getId() != null) : rule;
        assert (rule.getIPAddress() != null) : rule;
        assert (rule.getIPAddressId() != null) : rule;
        assert (rule.getStartPort() > 0) : rule;
        assert (rule.getProtocol() != null) : rule;
        assert (rule.getEndPort() > 0) : rule;
        assert (rule.getState() != null) : rule;
        assert (rule.getVirtualMachineId() != null) : rule;
        assert (rule.getVirtualMachineName() != null) : rule;
    }
}

