/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudstack.domain.StorageType;
import org.jclouds.cloudstack.domain.SystemVmType;
import org.jclouds.cloudstack.options.CreateServiceOfferingOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class CreateServiceOfferingOptionsTest {
    public void testHostTags() {
        CreateServiceOfferingOptions options = new CreateServiceOfferingOptions().hostTags((Set)ImmutableSet.of((Object)"tag1", (Object)"tag2"));
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"tag1", (Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"hosttags"));
    }

    public void testHostTagsStatic() {
        CreateServiceOfferingOptions options = CreateServiceOfferingOptions.Builder.hostTags((Set)ImmutableSet.of((Object)"tag1", (Object)"tag2"));
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"tag1", (Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"hosttags"));
    }

    public void testIsSystem() {
        CreateServiceOfferingOptions options = new CreateServiceOfferingOptions().isSystem(true);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"issystem"));
    }

    public void testIsSystemStatic() {
        CreateServiceOfferingOptions options = CreateServiceOfferingOptions.Builder.isSystem((boolean)true);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"issystem"));
    }

    public void testLimitCpuUse() {
        CreateServiceOfferingOptions options = new CreateServiceOfferingOptions().limitCpuUse(true);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"limitcpuuse"));
    }

    public void testLimitCpuUseStatic() {
        CreateServiceOfferingOptions options = CreateServiceOfferingOptions.Builder.limitCpuUse((boolean)true);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"limitcpuuse"));
    }

    public void testNetworkRate() {
        CreateServiceOfferingOptions options = new CreateServiceOfferingOptions().networkRateInMb(200);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"200"), (Collection)options.buildQueryParameters().get((Object)"networkrate"));
    }

    public void testNetworkRateStatic() {
        CreateServiceOfferingOptions options = CreateServiceOfferingOptions.Builder.networkRateInMb((int)200);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"200"), (Collection)options.buildQueryParameters().get((Object)"networkrate"));
    }

    public void testHighlyAvailable() {
        CreateServiceOfferingOptions options = new CreateServiceOfferingOptions().highlyAvailable(true);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"offerha"));
    }

    public void testHighlyAvailableStatic() {
        CreateServiceOfferingOptions options = CreateServiceOfferingOptions.Builder.highlyAvailable((boolean)true);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"true"), (Collection)options.buildQueryParameters().get((Object)"offerha"));
    }

    public void testStorageType() {
        CreateServiceOfferingOptions options = new CreateServiceOfferingOptions().storageType(StorageType.LOCAL);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"local"), (Collection)options.buildQueryParameters().get((Object)"storagetype"));
    }

    public void testStorageTypeStatic() {
        CreateServiceOfferingOptions options = CreateServiceOfferingOptions.Builder.storageType((StorageType)StorageType.LOCAL);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"local"), (Collection)options.buildQueryParameters().get((Object)"storagetype"));
    }

    public void testSystemVmType() {
        CreateServiceOfferingOptions options = new CreateServiceOfferingOptions().systemVmType(SystemVmType.DOMAIN_ROUTER);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"domainrouter"), (Collection)options.buildQueryParameters().get((Object)"systemvmtype"));
    }

    public void testSystemVmTypeStatic() {
        CreateServiceOfferingOptions options = CreateServiceOfferingOptions.Builder.systemVmType((SystemVmType)SystemVmType.DOMAIN_ROUTER);
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"domainrouter"), (Collection)options.buildQueryParameters().get((Object)"systemvmtype"));
    }

    public void testTags() {
        CreateServiceOfferingOptions options = new CreateServiceOfferingOptions().tags((Set)ImmutableSet.of((Object)"tag1", (Object)"tag2"));
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"tag1", (Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"tags"));
    }

    public void testTagsStatic() {
        CreateServiceOfferingOptions options = CreateServiceOfferingOptions.Builder.tags((Set)ImmutableSet.of((Object)"tag1", (Object)"tag2"));
        Assert.assertEquals((Collection)ImmutableSet.of((Object)"tag1", (Object)"tag2"), (Collection)options.buildQueryParameters().get((Object)"tags"));
    }
}

