/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class Capacity
implements Comparable<Capacity> {
    private final long capacityTotal;
    private final long capacityUsed;
    private final double percentUsed;
    private final String podId;
    private final String podName;
    private final Type type;
    private final String zoneId;
    private final String zoneName;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCapacity(this);
    }

    @ConstructorProperties(value={"capacitytotal", "capacityused", "percentused", "podid", "podname", "type", "zoneid", "zonename"})
    protected Capacity(long capacityTotal, long capacityUsed, double percentUsed, @Nullable String podId, @Nullable String podName, @Nullable Type type, @Nullable String zoneId, @Nullable String zoneName) {
        this.capacityTotal = capacityTotal;
        this.capacityUsed = capacityUsed;
        this.percentUsed = percentUsed;
        this.podId = podId;
        this.podName = podName;
        this.type = type;
        this.zoneId = zoneId;
        this.zoneName = zoneName;
    }

    public long getCapacityTotal() {
        return this.capacityTotal;
    }

    public long getCapacityUsed() {
        return this.capacityUsed;
    }

    public double getPercentUsed() {
        return this.percentUsed;
    }

    @Nullable
    public String getPodId() {
        return this.podId;
    }

    @Nullable
    public String getPodName() {
        return this.podName;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    @Nullable
    public String getZoneId() {
        return this.zoneId;
    }

    @Nullable
    public String getZoneName() {
        return this.zoneName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.capacityTotal, this.capacityUsed, this.percentUsed, this.podId, this.podName, this.type, this.zoneId, this.zoneName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Capacity that = (Capacity)Capacity.class.cast(obj);
        return Objects.equal((Object)this.capacityTotal, (Object)that.capacityTotal) && Objects.equal((Object)this.capacityUsed, (Object)that.capacityUsed) && Objects.equal((Object)this.percentUsed, (Object)that.percentUsed) && Objects.equal((Object)this.podId, (Object)that.podId) && Objects.equal((Object)this.podName, (Object)that.podName) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.zoneId, (Object)that.zoneId) && Objects.equal((Object)this.zoneName, (Object)that.zoneName);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("capacityTotal", this.capacityTotal).add("capacityUsed", this.capacityUsed).add("percentUsed", this.percentUsed).add("podId", (Object)this.podId).add("podName", (Object)this.podName).add("type", (Object)this.type).add("zoneId", (Object)this.zoneId).add("zoneName", (Object)this.zoneName);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(Capacity other) {
        int comparison = this.zoneId.compareTo(other.zoneId);
        if (comparison == 0) {
            comparison = this.podId.compareTo(other.podId);
        }
        if (comparison == 0) {
            Integer.valueOf(this.type.code).compareTo(other.type.code);
        }
        return comparison;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected long capacityTotal;
        protected long capacityUsed;
        protected double percentUsed;
        protected String podId;
        protected String podName;
        protected Type type;
        protected String zoneId;
        protected String zoneName;

        protected abstract T self();

        public T capacityTotal(long capacityTotal) {
            this.capacityTotal = capacityTotal;
            return this.self();
        }

        public T capacityUsed(long capacityUsed) {
            this.capacityUsed = capacityUsed;
            return this.self();
        }

        public T percentUsed(double percentUsed) {
            this.percentUsed = percentUsed;
            return this.self();
        }

        public T podId(String podId) {
            this.podId = podId;
            return this.self();
        }

        public T podName(String podName) {
            this.podName = podName;
            return this.self();
        }

        public T type(Type type) {
            this.type = type;
            return this.self();
        }

        public T zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this.self();
        }

        public T zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this.self();
        }

        public Capacity build() {
            return new Capacity(this.capacityTotal, this.capacityUsed, this.percentUsed, this.podId, this.podName, this.type, this.zoneId, this.zoneName);
        }

        public T fromCapacity(Capacity in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.capacityTotal(in.getCapacityTotal())).capacityUsed(in.getCapacityUsed())).percentUsed(in.getPercentUsed())).podId(in.getPodId())).podName(in.getPodName())).type(in.getType())).zoneId(in.getZoneId())).zoneName(in.getZoneName());
        }
    }

    public static enum Type {
        MEMORY_ALLOCATED_BYTES(0),
        CPU_ALLOCATED_MHZ(1),
        PRIMARY_STORAGE_USED_BYTES(2),
        PRIMARY_STORAGE_ALLOCATED_BYTES(3),
        PUBLIC_IP_ADDRESSES(4),
        PRIVATE_IP_ADDRESSES(5),
        SECONDARY_STORAGE_USED_BYTES(6),
        VLANS(7),
        DIRECT_ATTACHED_PUBLIC_IP_ADDRESSES(8),
        LOCAL_STORAGE_USED_BYTES(9),
        UNRECOGNIZED(Integer.MAX_VALUE);

        private int code;
        private static final Map<Integer, Type> INDEX;

        private Type(int code) {
            this.code = code;
        }

        public String toString() {
            return this.name();
        }

        public static Type fromValue(String type) {
            Integer code = Integer.valueOf((String)Preconditions.checkNotNull((Object)type, (Object)"type"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])Type.values()), (Function)new Function<Type, Integer>(){

                public Integer apply(Type input) {
                    return input.code;
                }
            });
        }
    }
}

