/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.features;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.cloudwatch.domain.ComparisonOperator;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.HistoryItemType;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.internal.BaseCloudWatchApiExpectTest;
import org.jclouds.cloudwatch.options.ListAlarmHistoryOptions;
import org.jclouds.cloudwatch.options.ListAlarmsForMetric;
import org.jclouds.cloudwatch.options.ListAlarmsOptions;
import org.jclouds.cloudwatch.options.SaveAlarmOptions;
import org.jclouds.cloudwatch.xml.ListAlarmHistoryResponseHandlerTest;
import org.jclouds.cloudwatch.xml.ListAlarmsForMetricResponseHandlerTest;
import org.jclouds.cloudwatch.xml.ListAlarmsResponseHandlerTest;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.io.Payload;
import org.jclouds.rest.InsufficientResourcesException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="AlarmApiExpectTest")
public class AlarmApiExpectTest
extends BaseCloudWatchApiExpectTest {
    private DateService dateService = new SimpleDateFormatDateService();
    private HttpRequest deleteAlarmsRequest = this.alarmRequest((Map<String, String>)ImmutableMap.of((Object)"Action", (Object)"DeleteAlarms", (Object)"AlarmNames.member.1", (Object)"TestAlarmName1", (Object)"AlarmNames.member.2", (Object)"TestAlarmName2", (Object)"Signature", (Object)"w9dhEBQCsmOhYKDp9Ht7/Ra6/xZcgAzhF0Bgtj8vpwQ%3D"));
    private HttpRequest putMetricAlarmRequest = this.alarmRequest((Map<String, String>)ImmutableMap.builder().put((Object)"Action", (Object)"PutMetricAlarm").put((Object)"ActionsEnabled", (Object)"true").put((Object)"AlarmActions.member.1", (Object)"TestAlarmAction1").put((Object)"AlarmActions.member.2", (Object)"TestAlarmAction2").put((Object)"AlarmDescription", (Object)"Test%20alarm%20description.").put((Object)"AlarmName", (Object)"TestAlarmName").put((Object)"ComparisonOperator", (Object)ComparisonOperator.GREATER_THAN_THRESHOLD.toString()).put((Object)"Dimensions.member.1.Name", (Object)"TestDimensionName1").put((Object)"Dimensions.member.1.Value", (Object)"TestDimensionValue1").put((Object)"Dimensions.member.2.Name", (Object)"TestDimensionName2").put((Object)"Dimensions.member.2.Value", (Object)"TestDimensionValue2").put((Object)"EvaluationPeriods", (Object)"60").put((Object)"InsufficientDataActions.member.1", (Object)"TestAlarmAction1").put((Object)"InsufficientDataActions.member.2", (Object)"TestAlarmAction2").put((Object)"MetricName", (Object)"TestMetricName").put((Object)"Namespace", (Object)"AWS/EBS").put((Object)"OKActions.member.1", (Object)"TestAlarmAction1").put((Object)"OKActions.member.2", (Object)"TestAlarmAction2").put((Object)"Period", (Object)"60").put((Object)"Statistic", (Object)Statistics.SAMPLE_COUNT.toString()).put((Object)"Threshold", (Object)"1.0").put((Object)"Unit", (Object)Unit.GIGABYTES_PER_SECOND.toString()).put((Object)"Signature", (Object)"6RXD%2Bp1393a0maPdMLn%2Bv%2BbIcOJnAViAtbMgcA%2BogWs%3D").build());
    private SaveAlarmOptions saveAlarmOptions = new SaveAlarmOptions().alarmActions((Set)ImmutableSet.of((Object)"TestAlarmAction1", (Object)"TestAlarmAction2")).alarmDescription("Test alarm description.").alarmName("TestAlarmName").metricName("TestMetricName").actionsEnabled(true).comparisonOperator(ComparisonOperator.GREATER_THAN_THRESHOLD).dimensions((Set)ImmutableSet.of((Object)new Dimension("TestDimensionName1", "TestDimensionValue1"), (Object)new Dimension("TestDimensionName2", "TestDimensionValue2"))).evaluationPeriods(60).insufficientDataActions((Set)ImmutableSet.of((Object)"TestAlarmAction1", (Object)"TestAlarmAction2")).namespace("AWS/EBS").okActions((Set)ImmutableSet.of((Object)"TestAlarmAction1", (Object)"TestAlarmAction2")).period(60).statistic(Statistics.SAMPLE_COUNT).threshold(1.0).unit(Unit.GIGABYTES_PER_SECOND);
    private HttpRequest setAlarmStateRequest = this.alarmRequest((Map<String, String>)ImmutableMap.builder().put((Object)"Action", (Object)"SetAlarmState").put((Object)"AlarmName", (Object)"TestAlarmName").put((Object)"StateReason", (Object)"TestStateReason").put((Object)"StateReasonData", (Object)"%7B%22reason%22%3A%20%22Some%20reason%22%7D").put((Object)"StateValue", (Object)Alarm.State.OK.toString()).put((Object)"Signature", (Object)"W3juJzJEoSTPfYnrK7s/Pbj4uA/PGNF7eoxa7NhByqU%3D").build());

    public AlarmApiExpectTest() {
        TimeZone.setDefault(TimeZone.getTimeZone("America/Los_Angeles"));
    }

    public void testSetAlarmStateIs2xx() throws Exception {
        Payload payload = this.payloadFromResourceWithContentType("/VoidResponse.xml", "text/xml");
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.setAlarmStateRequest, ((HttpResponse.Builder)HttpResponse.builder().payload(payload)).statusCode(200).build());
        cloudWatchApi.getAlarmApiForRegion(null).setState("TestAlarmName", "TestStateReason", "{\"reason\": \"Some reason\"}", Alarm.State.OK);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testSetAlarmStateIs400() throws Exception {
        Payload payload = this.payloadFromResourceWithContentType("/InvalidFormatResponse.xml", "text/xml");
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.setAlarmStateRequest, ((HttpResponse.Builder)HttpResponse.builder().payload(payload)).statusCode(400).build());
        cloudWatchApi.getAlarmApiForRegion(null).setState("TestAlarmName", "TestStateReason", "{\"reason\": \"Some reason\"}", Alarm.State.OK);
    }

    public void testPutMetricAlarmIs2xx() throws Exception {
        Payload payload = this.payloadFromResourceWithContentType("/VoidResponse.xml", "text/xml");
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.putMetricAlarmRequest, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(payload)).build());
        cloudWatchApi.getAlarmApiForRegion(null).save(this.saveAlarmOptions);
    }

    @Test(expectedExceptions={InsufficientResourcesException.class})
    public void testPutMetricAlarmIs400() throws Exception {
        Payload payload = this.payloadFromResourceWithContentType("/LimitExceededResponse.xml", "text/xml");
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.putMetricAlarmRequest, ((HttpResponse.Builder)HttpResponse.builder().payload(payload)).statusCode(400).build());
        cloudWatchApi.getAlarmApiForRegion(null).save(this.saveAlarmOptions);
    }

    public void testEnableAlarmActions() throws Exception {
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.alarmRequest((Map<String, String>)ImmutableMap.of((Object)"Action", (Object)"EnableAlarmActions", (Object)"AlarmNames.member.1", (Object)"TestAlarmName1", (Object)"AlarmNames.member.2", (Object)"TestAlarmName2", (Object)"Signature", (Object)"Q1VemnXpc57PKMs9NVCX6R%2B/TSDgsGzQwpOHQ70aJuU%3D")), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/VoidResponse.xml", "text/xml"))).build());
        cloudWatchApi.getAlarmApiForRegion(null).enable((Iterable)ImmutableSet.of((Object)"TestAlarmName1", (Object)"TestAlarmName2"));
    }

    public void testDisableAlarmActions() throws Exception {
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.alarmRequest((Map<String, String>)ImmutableMap.of((Object)"Action", (Object)"DisableAlarmActions", (Object)"AlarmNames.member.1", (Object)"TestAlarmName1", (Object)"AlarmNames.member.2", (Object)"TestAlarmName2", (Object)"Signature", (Object)"tvSfJ%2BgcrHowwUECSniV0TQP2OObpWCuba0S5dd723Y%3D")), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/VoidResponse.xml", "text/xml"))).build());
        cloudWatchApi.getAlarmApiForRegion(null).disable((Iterable)ImmutableSet.of((Object)"TestAlarmName1", (Object)"TestAlarmName2"));
    }

    public void testDescribeAlarmsForMetric() throws Exception {
        String metricName = "TestMetricName";
        String namespace = "AWS/EC2";
        int period = 60;
        Statistics statistics = Statistics.SAMPLE_COUNT;
        Unit unit = Unit.SECONDS;
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.alarmRequest((Map<String, String>)ImmutableMap.builder().put((Object)"Action", (Object)"DescribeAlarmsForMetric").put((Object)"Dimensions.member.1.Name", (Object)"TestDimensionName1").put((Object)"Dimensions.member.1.Value", (Object)"TestDimensionValue1").put((Object)"Dimensions.member.2.Name", (Object)"TestDimensionName2").put((Object)"Dimensions.member.2.Value", (Object)"TestDimensionValue2").put((Object)"MetricName", (Object)metricName).put((Object)"Namespace", (Object)namespace).put((Object)"Period", (Object)Integer.toString(period)).put((Object)"Statistic", (Object)statistics.toString()).put((Object)"Unit", (Object)unit.toString()).put((Object)"Signature", (Object)"y%2BpU0Lp6AAO2QSrNld1VQY4DhKVHcyn44dIfnrmJhpg%3D").build()), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/DescribeAlarmsForMetricResponse.xml", "text/xml"))).build());
        Assert.assertEquals((String)new ListAlarmsForMetricResponseHandlerTest().expected().toString(), (String)cloudWatchApi.getAlarmApiForRegion(null).listForMetric(new ListAlarmsForMetric().dimensions((Set)ImmutableSet.of((Object)new Dimension("TestDimensionName1", "TestDimensionValue1"), (Object)new Dimension("TestDimensionName2", "TestDimensionValue2"))).metricName(metricName).namespace(namespace).period(period).statistic(statistics).unit(unit)).toString());
    }

    public void testDescribeAlarms() throws Exception {
        String actionPrefix = "TestActionPrefix";
        String alarmNamePrefix = "TestAlarmNamePrefix";
        ImmutableSet alarmNames = ImmutableSet.of((Object)"TestAlarmName1", (Object)"TestAlarmName2");
        int maxRecords = 10;
        Alarm.State state = Alarm.State.ALARM;
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.alarmRequest((Map<String, String>)ImmutableMap.builder().put((Object)"Action", (Object)"DescribeAlarms").put((Object)"ActionPrefix", (Object)actionPrefix).put((Object)"AlarmNamePrefix", (Object)alarmNamePrefix).put((Object)"AlarmNames.member.1", (Object)"TestAlarmName1").put((Object)"AlarmNames.member.2", (Object)"TestAlarmName2").put((Object)"MaxRecords", (Object)Integer.toString(maxRecords)).put((Object)"StateValue", (Object)state.toString()).put((Object)"Signature", (Object)"jPP1enbHPfOphIZv796W0KN4/EsLdPp6nK1qpbt5Dog%3D").build()), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/DescribeAlarmsResponse.xml", "text/xml"))).build());
        Assert.assertEquals((String)new ListAlarmsResponseHandlerTest().expected().toString(), (String)((IterableWithMarker)cloudWatchApi.getAlarmApiForRegion(null).list(new ListAlarmsOptions().actionPrefix(actionPrefix).alarmNamePrefix(alarmNamePrefix).alarmNames((Set)alarmNames).maxRecords(maxRecords).state(state)).get(0)).toString());
    }

    public void testDescribeAlarmHistory() throws Exception {
        String alarmName = "TestAlarmName";
        HistoryItemType historyItemType = HistoryItemType.ACTION;
        int maxRecords = 10;
        String endDateStr = "2013-01-02T00:00:00.000Z";
        String startDateStr = "2013-01-01T00:00:00.000Z";
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.alarmRequest((Map<String, String>)ImmutableMap.builder().put((Object)"Action", (Object)"DescribeAlarmHistory").put((Object)"AlarmName", (Object)alarmName).put((Object)"EndDate", (Object)"2013-01-02T00%3A00%3A00.000Z").put((Object)"HistoryItemType", (Object)historyItemType.toString()).put((Object)"MaxRecords", (Object)Integer.toString(maxRecords)).put((Object)"StartDate", (Object)"2013-01-01T00%3A00%3A00.000Z").put((Object)"Signature", (Object)"O2u9yIQvCuVpKdUeUDJcswri0YD0sD4%2B/SR5TtYbPeQ%3D").build()), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/DescribeAlarmHistoryResponse.xml", "text/xml"))).build());
        Assert.assertEquals((String)new ListAlarmHistoryResponseHandlerTest().expected().toString(), (String)((IterableWithMarker)cloudWatchApi.getAlarmApiForRegion(null).listHistory(new ListAlarmHistoryOptions().alarmName("TestAlarmName").endDate(this.dateService.iso8601DateParse(endDateStr)).historyItemType(HistoryItemType.ACTION).maxRecords(maxRecords).startDate(this.dateService.iso8601DateParse(startDateStr))).get(0)).toString());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testDeleteAlarmsIs404() throws Exception {
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.deleteAlarmsRequest, HttpResponse.builder().statusCode(404).build());
        cloudWatchApi.getAlarmApiForRegion(null).delete((Iterable)ImmutableSet.of((Object)"TestAlarmName1", (Object)"TestAlarmName2"));
    }

    public void testDeleteAlarmsIs2xx() throws Exception {
        Payload payload = this.payloadFromResourceWithContentType("/VoidResponse.xml", "text/xml");
        CloudWatchApi cloudWatchApi = (CloudWatchApi)this.requestSendsResponse(this.deleteAlarmsRequest, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(payload)).build());
        cloudWatchApi.getAlarmApiForRegion(null).delete((Iterable)ImmutableSet.of((Object)"TestAlarmName1", (Object)"TestAlarmName2"));
    }

    private HttpRequest alarmRequest(Map<String, String> arguments) {
        TreeMap sortedArguments = Maps.newTreeMap();
        ImmutableMap defaultArguments = ImmutableMap.builder().put((Object)"SignatureMethod", (Object)"HmacSHA256").put((Object)"SignatureVersion", (Object)"2").put((Object)"Timestamp", (Object)"2009-11-08T15%3A54%3A08.897Z").put((Object)"Version", (Object)"2010-08-01").build();
        sortedArguments.putAll(arguments);
        for (Map.Entry defaultArgument : defaultArguments.entrySet()) {
            if (sortedArguments.containsKey(defaultArgument.getKey())) continue;
            sortedArguments.put(defaultArgument.getKey(), defaultArgument.getValue());
        }
        LinkedHashMap realArguments = Maps.newLinkedHashMap((Map)sortedArguments);
        realArguments.put("AWSAccessKeyId", "identity");
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://monitoring.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"monitoring.us-east-1.amazonaws.com"})).payload(AlarmApiExpectTest.payloadFromStringWithContentType((String)Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)realArguments).trim(), (String)"application/x-www-form-urlencoded"))).build();
    }
}

