/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.config;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.aws.config.FormSigningRestClientModule;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.CloudWatchAsyncApi;
import org.jclouds.cloudwatch.features.AlarmApi;
import org.jclouds.cloudwatch.features.AlarmAsyncApi;
import org.jclouds.cloudwatch.features.MetricApi;
import org.jclouds.cloudwatch.features.MetricAsyncApi;
import org.jclouds.cloudwatch.handlers.CloudWatchErrorHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;

@ConfiguresRestClient
public class CloudWatchRestClientModule
extends FormSigningRestClientModule<CloudWatchApi, CloudWatchAsyncApi> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(MetricApi.class, MetricAsyncApi.class).put(AlarmApi.class, AlarmAsyncApi.class).build();

    public CloudWatchRestClientModule() {
        super(Reflection2.typeToken(CloudWatchApi.class), Reflection2.typeToken(CloudWatchAsyncApi.class), DELEGATE_MAP);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(CloudWatchErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(CloudWatchErrorHandler.class);
    }
}

