/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import org.jclouds.ec2.binders.BindTagsToIndexedFormParams;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindTagsToIndexedFormParamsTest {
    BindTagsToIndexedFormParams binder = new BindTagsToIndexedFormParams();

    public void test() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)ImmutableMap.of((Object)"one", (Object)"alpha", (Object)"two", (Object)"beta"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"Tag.1.Key=one&Tag.1.Value=alpha&Tag.2.Key=two&Tag.2.Value=beta");
    }

    public void testEmpty() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)ImmutableSet.of((Object)"empty"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"Tag.1.Key=empty&Tag.1.Value=");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeArray() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

