/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Provider;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.domain.EC2HardwareBuilder;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.functions.ImagesToRegionAndIdMap;
import org.jclouds.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="EC2TemplateBuilderTest")
public class EC2TemplateBuilderTest {
    Location provider = new LocationBuilder().scope(LocationScope.PROVIDER).id("aws-ec2").description("aws-ec2").build();
    protected Location location = new LocationBuilder().scope(LocationScope.REGION).id("us-east-1").description("us-east-1").parent(this.provider).build();
    public static final Hardware CC1_4XLARGE = EC2HardwareBuilder.cc1_4xlarge().supportsImageIds((Iterable)ImmutableSet.of((Object)"us-east-1/cc-image")).build();

    @Test
    public void testTemplateChoiceForInstanceByhardwareId() throws Exception {
        Template template = this.newTemplateBuilder().os64Bit(true).hardwareId("m2.xlarge").locationId("us-east-1").build();
        assert (template != null) : "The returned template was null, but it should have a value.";
        Assert.assertEquals((String)EC2HardwareBuilder.m2_xlarge().build().getId(), (String)template.getHardware().getId());
    }

    @Test
    public void testTemplateChoiceForInstanceByCChardwareId() throws Exception {
        Template template = this.newTemplateBuilder().fastest().build();
        assert (template != null) : "The returned template was null, but it should have a value.";
        assert (CC1_4XLARGE.equals(template.getHardware())) : String.format("Incorrect image determined by the template. Expected: %s. Found: %s.", CC1_4XLARGE.getId(), template.getHardware().getId());
    }

    @Test
    public void testTemplateChoiceForInstanceByAttributes() throws Exception {
        Template template = this.newTemplateBuilder().os64Bit(true).minRam(17510).minCores(6.5).smallest().locationId("us-east-1").build();
        assert (template != null) : "The returned template was null, but it should have a value.";
        Assert.assertEquals((String)template.getHardware().getId(), (String)"cc1.4xlarge");
    }

    @Test
    public void testNegativeTemplateChoiceForInstanceByAttributes() throws Exception {
        Template template = this.newTemplateBuilder().os64Bit(true).minRam(17510).minCores(6.7).smallest().locationId("us-east-1").build();
        assert (template != null) : "The returned template was null, but it should have a value.";
        assert (!EC2HardwareBuilder.m2_xlarge().build().equals(template.getHardware())) : String.format("Incorrect image determined by the template. Expected: not %s. Found: %s.", "m2.xlarge", template.getHardware().getId());
    }

    @Test
    public void testTemplateChoiceForInstanceByImageId() throws Exception {
        Template template = this.newTemplateBuilder().imageId("us-east-1/cc-image").build();
        assert (template != null) : "The returned template was null, but it should have a value.";
        Assert.assertEquals((String)template.getImage().getId(), (String)"us-east-1/cc-image");
    }

    @Test
    public void testTemplateChoiceForInstanceByImageIdDoesNotGetAllImages() throws Exception {
        Supplier images = (Supplier)EasyMock.createMock(Supplier.class);
        EasyMock.replay((Object[])new Object[]{images});
        Image image = new ImageBuilder().providerId("cc-image").name("image").id("us-east-1/cc-image").location(this.location).operatingSystem(new OperatingSystem(OsFamily.UBUNTU, null, "1.0", "hvm", "ubuntu", true)).description("description").version("1.0").defaultCredentials(LoginCredentials.builder().user("root").build()).status(Image.Status.AVAILABLE).build();
        ImmutableMap imageMap = ImmutableMap.of((Object)new RegionAndName(image.getLocation().getId(), image.getProviderId()), (Object)image);
        Supplier imageCache = Suppliers.ofInstance((Object)CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap((Map)imageMap))));
        Template template = this.newTemplateBuilder((Supplier<Set<? extends Image>>)images, (Supplier<LoadingCache<RegionAndName, ? extends Image>>)imageCache).imageId("us-east-1/cc-image").build();
        assert (template != null) : "The returned template was null, but it should have a value.";
        Assert.assertEquals((String)template.getImage().getId(), (String)"us-east-1/cc-image");
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testNegativeTemplateChoiceForInstanceByImageId() throws Exception {
        this.newTemplateBuilder().imageId("wrongregion/wrongimageid").build();
    }

    private TemplateBuilder newTemplateBuilder() {
        Supplier images = Suppliers.ofInstance((Object)ImmutableSet.of((Object)new ImageBuilder().providerId("cc-image").name("image").id("us-east-1/cc-image").location(this.location).operatingSystem(new OperatingSystem(OsFamily.UBUNTU, null, "1.0", "hvm", "ubuntu", true)).description("description").version("1.0").defaultCredentials(LoginCredentials.builder().user("root").build()).status(Image.Status.AVAILABLE).build(), (Object)new ImageBuilder().providerId("normal-image").name("image").id("us-east-1/normal-image").location(this.location).operatingSystem(new OperatingSystem(OsFamily.UBUNTU, null, "1.0", "paravirtual", "ubuntu", true)).description("description").version("1.0").defaultCredentials(LoginCredentials.builder().user("root").build()).status(Image.Status.AVAILABLE).build()));
        ImmutableMap imageMap = (ImmutableMap)ImagesToRegionAndIdMap.imagesToMap((Iterable)((Iterable)images.get()));
        Supplier imageCache = Suppliers.ofInstance((Object)CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap((Map)imageMap))));
        return this.newTemplateBuilder((Supplier<Set<? extends Image>>)images, (Supplier<LoadingCache<RegionAndName, ? extends Image>>)imageCache);
    }

    private TemplateBuilder newTemplateBuilder(Supplier<Set<? extends Image>> images, Supplier<LoadingCache<RegionAndName, ? extends Image>> imageCache) {
        Provider optionsProvider = (Provider)EasyMock.createMock(Provider.class);
        Provider templateBuilderProvider = (Provider)EasyMock.createMock(Provider.class);
        TemplateOptions defaultOptions = (TemplateOptions)EasyMock.createMock(TemplateOptions.class);
        EasyMock.expect((Object)optionsProvider.get()).andReturn((Object)defaultOptions);
        EasyMock.replay((Object[])new Object[]{optionsProvider});
        EasyMock.replay((Object[])new Object[]{templateBuilderProvider});
        Supplier locations = Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.location));
        Supplier sizes = Suppliers.ofInstance((Object)ImmutableSet.of((Object)EC2HardwareBuilder.t1_micro().build(), (Object)EC2HardwareBuilder.c1_medium().build(), (Object)EC2HardwareBuilder.c1_xlarge().build(), (Object)EC2HardwareBuilder.m1_large().build(), (Object)EC2HardwareBuilder.m1_small().build(), (Object)EC2HardwareBuilder.m1_xlarge().build(), (Object[])new Hardware[]{EC2HardwareBuilder.m2_xlarge().build(), EC2HardwareBuilder.m2_2xlarge().build(), EC2HardwareBuilder.m2_4xlarge().build(), EC2HardwareBuilder.g2_2xlarge().build(), CC1_4XLARGE}));
        return new EC2TemplateBuilderImpl(locations, images, sizes, Suppliers.ofInstance((Object)this.location), optionsProvider, templateBuilderProvider, imageCache){};
    }

    Function<ComputeMetadata, String> indexer() {
        return new Function<ComputeMetadata, String>(){

            public String apply(ComputeMetadata from) {
                return from.getProviderId();
            }
        };
    }
}

