/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ec2.internal.BaseEC2ClientExpectTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.location.Region;
import org.jclouds.location.Zone;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.location.functions.ZoneToEndpoint;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EC2RestClientModuleExpectTest")
public class EC2RestClientModuleExpectTest
extends BaseEC2ClientExpectTest<Injector> {
    private Injector injector;

    @Override
    @BeforeClass
    protected void setupDefaultRequests() {
        super.setupDefaultRequests();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        builder.putAll(this.describeAvailabilityZonesRequestResponse);
        this.injector = (Injector)this.requestsSendResponses((Map)builder.build());
    }

    public void testLocationIdAndURIBindings() {
        Assert.assertEquals((Set)((Set)((Supplier)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<Set<String>>>(){}, Region.class))).get()), (Set)ImmutableSet.of((Object)"sa-east-1", (Object)"ap-northeast-1", (Object)"eu-west-1", (Object)"us-east-1", (Object)"us-west-1", (Object)"us-west-2", (Object[])new String[]{"ap-southeast-1"}));
        Assert.assertEquals((Set)((Set)((Supplier)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<Set<String>>>(){}, Zone.class))).get()), (Set)ImmutableSet.of((Object)"sa-east-1a", (Object)"sa-east-1b", (Object)"ap-northeast-1a", (Object)"ap-northeast-1b", (Object)"eu-west-1a", (Object)"eu-west-1b", (Object[])new String[]{"eu-west-1c", "us-east-1a", "us-east-1b", "us-east-1c", "us-east-1d", "us-east-1e", "us-west-1a", "us-west-1b", "us-west-1c", "us-west-2a", "us-west-2b", "us-west-2c", "ap-southeast-1a", "ap-southeast-1b"}));
        Map regionToURISupplier = (Map)((Supplier)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<Map<String, Supplier<URI>>>>(){}, Region.class))).get();
        Assert.assertEquals((Object)((Supplier)regionToURISupplier.get("sa-east-1")).get(), (Object)URI.create("https://ec2.sa-east-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)regionToURISupplier.get("ap-northeast-1")).get(), (Object)URI.create("https://ec2.ap-northeast-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)regionToURISupplier.get("eu-west-1")).get(), (Object)URI.create("https://ec2.eu-west-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)regionToURISupplier.get("us-east-1")).get(), (Object)URI.create("https://ec2.us-east-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)regionToURISupplier.get("us-west-1")).get(), (Object)URI.create("https://ec2.us-west-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)regionToURISupplier.get("us-west-2")).get(), (Object)URI.create("https://ec2.us-west-2.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)regionToURISupplier.get("ap-southeast-1")).get(), (Object)URI.create("https://ec2.ap-southeast-1.amazonaws.com"));
        Map regionToZoneIdSupplier = (Map)((Supplier)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<Map<String, Supplier<Set<String>>>>>(){}, Zone.class))).get();
        Assert.assertEquals((Set)((Set)((Supplier)regionToZoneIdSupplier.get("sa-east-1")).get()), (Set)ImmutableSet.of((Object)"sa-east-1a", (Object)"sa-east-1b"));
        Assert.assertEquals((Set)((Set)((Supplier)regionToZoneIdSupplier.get("ap-northeast-1")).get()), (Set)ImmutableSet.of((Object)"ap-northeast-1a", (Object)"ap-northeast-1b"));
        Assert.assertEquals((Set)((Set)((Supplier)regionToZoneIdSupplier.get("eu-west-1")).get()), (Set)ImmutableSet.of((Object)"eu-west-1a", (Object)"eu-west-1b", (Object)"eu-west-1c"));
        Assert.assertEquals((Set)((Set)((Supplier)regionToZoneIdSupplier.get("us-east-1")).get()), (Set)ImmutableSet.of((Object)"us-east-1a", (Object)"us-east-1b", (Object)"us-east-1c", (Object)"us-east-1d", (Object)"us-east-1e"));
        Assert.assertEquals((Set)((Set)((Supplier)regionToZoneIdSupplier.get("us-west-1")).get()), (Set)ImmutableSet.of((Object)"us-west-1a", (Object)"us-west-1b", (Object)"us-west-1c"));
        Assert.assertEquals((Set)((Set)((Supplier)regionToZoneIdSupplier.get("us-west-2")).get()), (Set)ImmutableSet.of((Object)"us-west-2a", (Object)"us-west-2b", (Object)"us-west-2c"));
        Assert.assertEquals((Set)((Set)((Supplier)regionToZoneIdSupplier.get("ap-southeast-1")).get()), (Set)ImmutableSet.of((Object)"ap-southeast-1a", (Object)"ap-southeast-1b"));
        Map zoneToURISupplier = (Map)((Supplier)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Supplier<Map<String, Supplier<URI>>>>(){}, Zone.class))).get();
        Assert.assertEquals((Object)((Supplier)zoneToURISupplier.get("sa-east-1a")).get(), (Object)URI.create("https://ec2.sa-east-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)zoneToURISupplier.get("ap-northeast-1a")).get(), (Object)URI.create("https://ec2.ap-northeast-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)zoneToURISupplier.get("eu-west-1a")).get(), (Object)URI.create("https://ec2.eu-west-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)zoneToURISupplier.get("us-east-1a")).get(), (Object)URI.create("https://ec2.us-east-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)zoneToURISupplier.get("us-west-1a")).get(), (Object)URI.create("https://ec2.us-west-1.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)zoneToURISupplier.get("us-west-2a")).get(), (Object)URI.create("https://ec2.us-west-2.amazonaws.com"));
        Assert.assertEquals((Object)((Supplier)zoneToURISupplier.get("ap-southeast-1a")).get(), (Object)URI.create("https://ec2.ap-southeast-1.amazonaws.com"));
    }

    public void testZoneToEndpoint() {
        Assert.assertEquals((Object)((ZoneToEndpoint)this.injector.getInstance(ZoneToEndpoint.class)).apply((Object)"us-west-2a"), (Object)URI.create("https://ec2.us-west-2.amazonaws.com"));
    }

    public void testRegionToEndpointOrProviderIfNull() {
        Assert.assertEquals((Object)((RegionToEndpointOrProviderIfNull)this.injector.getInstance(RegionToEndpointOrProviderIfNull.class)).apply((Object)"us-west-2"), (Object)URI.create("https://ec2.us-west-2.amazonaws.com"));
    }

    public Injector createClient(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return this.createInjector(fn, module, props);
    }
}

