/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Properties;
import java.util.Set;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.features.SubnetApi;
import org.jclouds.ec2.internal.BaseEC2ApiExpectTest;
import org.jclouds.ec2.parse.DescribeSubnetsResponseTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SubnetApiExpectTest
extends BaseEC2ApiExpectTest<EC2Api> {
    HttpRequest list = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSubnets"}).addFormParam("Signature", new String[]{"Uuafp9lnYQmMUcf/JE1epPTQVCSMPqfns%2BwlZssUsi4%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2012-04-16T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-01-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest filter = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeSubnets"}).addFormParam("Filter.1.Name", new String[]{"subnet-id"}).addFormParam("Filter.1.Value.1", new String[]{"subnet-9d4a7b6c"}).addFormParam("Signature", new String[]{"%2Bp34YACfLk9km1H3eALnDmrkst9FhJttojVSf7VztLk%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2012-04-16T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-01-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.put("jclouds.api-version", "2011-01-01");
        return props;
    }

    public void testListWhenResponseIs2xx() throws Exception {
        HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_subnets.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.list, listResponse);
        Assert.assertEquals((String)((SubnetApi)apiWhenExist.getSubnetApi().get()).list().toString(), (String)new DescribeSubnetsResponseTest().expected().toString());
    }

    public void testListWhenResponseIs404() throws Exception {
        HttpResponse listResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.list, listResponse);
        Assert.assertEquals((Set)((SubnetApi)apiWhenDontExist.getSubnetApi().get()).list().toSet(), (Set)ImmutableSet.of());
    }

    public void testFilterWhenResponseIs2xx() throws Exception {
        HttpResponse filterResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/describe_subnets.xml", "text/xml"))).build();
        EC2Api apiWhenExist = (EC2Api)this.requestSendsResponse(this.filter, filterResponse);
        Assert.assertEquals((String)((SubnetApi)apiWhenExist.getSubnetApi().get()).filter((Multimap)ImmutableMultimap.builder().put((Object)"subnet-id", (Object)"subnet-9d4a7b6c").build()).toString(), (String)new DescribeSubnetsResponseTest().expected().toString());
    }

    public void testFilterWhenResponseIs404() throws Exception {
        HttpResponse filterResponse = HttpResponse.builder().statusCode(404).build();
        EC2Api apiWhenDontExist = (EC2Api)this.requestSendsResponse(this.filter, filterResponse);
        Assert.assertEquals((Set)((SubnetApi)apiWhenDontExist.getSubnetApi().get()).filter((Multimap)ImmutableMultimap.builder().put((Object)"subnet-id", (Object)"subnet-9d4a7b6c").build()).toSet(), (Set)ImmutableSet.of());
    }
}

