/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.Tag;
import org.jclouds.ec2.features.TagApi;
import org.jclouds.ec2.internal.BaseEC2ApiLiveTest;
import org.jclouds.ec2.util.TagFilterBuilder;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"})
public abstract class BaseTagApiLiveTest
extends BaseEC2ApiLiveTest {
    private Resource resource;
    private Tag tag;
    private Tag tag2;

    public void testApplyTag() {
        this.api().applyToResources((Iterable)ImmutableSet.of((Object)"foo"), (Iterable)ImmutableSet.of((Object)this.resource.id));
        this.tag = (Tag)this.api().filter((Multimap)new TagFilterBuilder().resourceId(this.resource.id).key("foo").build()).get(0);
        Logger.getAnonymousLogger().info("created tag: " + this.tag);
        Assert.assertEquals((String)this.tag.getKey(), (String)"foo");
        Assert.assertEquals((String)this.tag.getResourceId(), (String)this.resource.id);
        Assert.assertEquals((String)this.tag.getResourceType(), (String)this.resource.type);
        Assert.assertFalse((boolean)this.tag.getValue().isPresent());
    }

    public void testApplyTagWithValue() {
        this.api().applyToResources((Map)ImmutableMap.of((Object)"type", (Object)"bar"), (Iterable)ImmutableSet.of((Object)this.resource.id));
        this.tag2 = (Tag)this.api().filter((Multimap)new TagFilterBuilder().resourceId(this.resource.id).key("type").build()).get(0);
        Logger.getAnonymousLogger().info("created tag: " + this.tag2);
        Assert.assertEquals((String)this.tag2.getKey(), (String)"type");
        Assert.assertEquals((String)this.tag2.getResourceId(), (String)this.resource.id);
        Assert.assertEquals((String)this.tag2.getResourceType(), (String)this.resource.type);
        Assert.assertEquals((String)((String)this.tag2.getValue().get()), (String)"bar");
    }

    @Test(dependsOnMethods={"testApplyTag", "testApplyTagWithValue"})
    protected void testList() {
        Assert.assertTrue((boolean)Predicates2.retry((Predicate)new Predicate<Iterable<Tag>>(){

            public boolean apply(Iterable<Tag> input) {
                return BaseTagApiLiveTest.this.api().list().filter((Predicate)new Predicate<Tag>(){

                    public boolean apply(Tag in) {
                        return in.getResourceId().equals(((BaseTagApiLiveTest)BaseTagApiLiveTest.this).resource.id);
                    }
                }).toSet().equals(input);
            }
        }, (long)600L, (long)200L, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS).apply((Object)ImmutableSet.of((Object)this.tag, (Object)this.tag2)));
    }

    @Test(dependsOnMethods={"testList"})
    public void testDeleteTags() {
        this.api().conditionallyDeleteFromResources((Map)ImmutableMap.of((Object)this.tag.getKey(), (Object)"FOO", (Object)this.tag2.getKey(), (Object)"FOO"), (Iterable)ImmutableSet.of((Object)this.tag.getResourceId(), (Object)this.tag2.getResourceId()));
        Assert.assertEquals((int)this.tagsForResource().size(), (int)2);
        this.api().deleteFromResources((Iterable)ImmutableSet.of((Object)this.tag.getKey(), (Object)this.tag2.getKey()), (Iterable)ImmutableSet.of((Object)this.tag.getResourceId(), (Object)this.tag2.getResourceId()));
        Assert.assertEquals((int)this.tagsForResource().size(), (int)0);
        Logger.getAnonymousLogger().info("tags deleted: " + this.tag + ", " + this.tag2);
    }

    private FluentIterable<Tag> tagsForResource() {
        return this.api().filter((Multimap)new TagFilterBuilder().resourceId(this.resource.id).build());
    }

    @BeforeClass(groups={"live"})
    public void setup() {
        super.setup();
        this.resource = (Resource)Preconditions.checkNotNull((Object)this.createResourceForTagging(System.getProperty("user.name") + "-tag"), (Object)"resource");
    }

    protected abstract Resource createResourceForTagging(String var1);

    protected abstract void cleanupResource(Resource var1);

    protected TagApi api() {
        Optional tagOption = ((EC2Api)this.api).getTagApi();
        if (!tagOption.isPresent()) {
            throw new SkipException("tag api not present");
        }
        return (TagApi)tagOption.get();
    }

    @AfterClass(groups={"live"})
    protected void tearDown() {
        if (this.resource != null) {
            this.cleanupResource(this.resource);
        }
        super.tearDown();
    }

    public static class Resource {
        public String id;
        public String type;

        public Resource(String id, String type) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.type = (String)Preconditions.checkNotNull((Object)type, (String)"type of %s", (Object[])new Object[]{id});
        }
    }
}

