/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.ec2.options.DescribeSnapshotsOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DescribeSnapshotsOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(DescribeSnapshotsOptions.class));
        assert (!String.class.isAssignableFrom(DescribeSnapshotsOptions.class));
    }

    @Test
    public void testRestorableBy() {
        DescribeSnapshotsOptions options = new DescribeSnapshotsOptions();
        options.restorableBy(new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RestorableBy.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullRestorableBy() {
        DescribeSnapshotsOptions options = new DescribeSnapshotsOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RestorableBy.1"), (Collection)ImmutableList.of());
    }

    @Test
    public void testRestorableByStatic() {
        DescribeSnapshotsOptions options = DescribeSnapshotsOptions.Builder.restorableBy((String[])new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RestorableBy.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testOwners() {
        DescribeSnapshotsOptions options = new DescribeSnapshotsOptions();
        options.ownedBy(new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testMultipleOwners() {
        DescribeSnapshotsOptions options = new DescribeSnapshotsOptions();
        options.ownedBy(new String[]{"test", "trouble"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of((Object)"test"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.2"), (Collection)ImmutableList.of((Object)"trouble"));
    }

    @Test
    public void testNullOwners() {
        DescribeSnapshotsOptions options = new DescribeSnapshotsOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of());
    }

    @Test
    public void testOwnersStatic() {
        DescribeSnapshotsOptions options = DescribeSnapshotsOptions.Builder.ownedBy((String[])new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Owner.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    public void testNoOwners() {
        DescribeSnapshotsOptions.Builder.ownedBy((String[])new String[0]);
    }

    @Test
    public void testSnapshotIds() {
        DescribeSnapshotsOptions options = new DescribeSnapshotsOptions();
        options.snapshotIds(new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SnapshotId.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testMultipleSnapshotIds() {
        DescribeSnapshotsOptions options = new DescribeSnapshotsOptions();
        options.snapshotIds(new String[]{"test", "trouble"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SnapshotId.1"), (Collection)ImmutableList.of((Object)"test"));
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SnapshotId.2"), (Collection)ImmutableList.of((Object)"trouble"));
    }

    @Test
    public void testNullSnapshotIds() {
        DescribeSnapshotsOptions options = new DescribeSnapshotsOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SnapshotId.1"), (Collection)ImmutableList.of());
    }

    @Test
    public void testSnapshotIdsStatic() {
        DescribeSnapshotsOptions options = DescribeSnapshotsOptions.Builder.snapshotIds((String[])new String[]{"test"});
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"SnapshotId.1"), (Collection)ImmutableList.of((Object)"test"));
    }

    public void testNoSnapshotIds() {
        DescribeSnapshotsOptions.Builder.snapshotIds((String[])new String[0]);
    }
}

