/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.Collection;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.options.RegisterImageBackedByEbsOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RegisterImageBackedByEbsOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(RegisterImageBackedByEbsOptions.class));
        assert (!String.class.isAssignableFrom(RegisterImageBackedByEbsOptions.class));
    }

    @Test
    public void testWithDescription() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.withDescription("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithDescription() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithDescriptionStatic() {
        RegisterImageBackedByEbsOptions options = RegisterImageBackedByEbsOptions.Builder.withDescription((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithDescriptionNPE() {
        RegisterImageBackedByEbsOptions.Builder.withDescription(null);
    }

    @Test
    public void testWithArchitecture() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.asArchitecture(Image.Architecture.I386);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Architecture"), (Collection)ImmutableList.of((Object)"i386"));
    }

    @Test
    public void testNullWithArchitecture() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Architecture"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithArchitectureStatic() {
        RegisterImageBackedByEbsOptions options = RegisterImageBackedByEbsOptions.Builder.asArchitecture((Image.Architecture)Image.Architecture.I386);
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"Architecture"), (Collection)ImmutableList.of((Object)"i386"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithArchitectureNPE() {
        RegisterImageBackedByEbsOptions.Builder.asArchitecture(null);
    }

    @Test
    public void testWithKernelId() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.withKernelId("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithKernelId() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithKernelIdStatic() {
        RegisterImageBackedByEbsOptions options = RegisterImageBackedByEbsOptions.Builder.withKernelId((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"KernelId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithKernelIdNPE() {
        RegisterImageBackedByEbsOptions.Builder.withKernelId(null);
    }

    @Test
    public void testWithRamdisk() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.withRamdisk("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullWithRamdisk() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithRamdiskStatic() {
        RegisterImageBackedByEbsOptions options = RegisterImageBackedByEbsOptions.Builder.withRamdisk((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"RamdiskId"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithRamdiskNPE() {
        RegisterImageBackedByEbsOptions.Builder.withRamdisk(null);
    }

    @Test
    public void testAddBlockDeviceFromSnapshot() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.addBlockDeviceFromSnapshot("deviceName", "virtualName", "snapshotId");
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination", (Object)"false", (Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.VirtualName", (Object)"virtualName", (Object)"BlockDeviceMapping.1.Ebs.SnapshotId", (Object)"snapshotId").entries());
    }

    @Test
    public void testAddBlockDeviceFromSnapshotNullVirtualName() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.addBlockDeviceFromSnapshot("deviceName", null, "snapshotId");
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination", (Object)"false", (Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.Ebs.SnapshotId", (Object)"snapshotId").entries());
    }

    @Test
    public void testNullAddBlockDeviceFromSnapshot() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        Assert.assertEquals((Object)options.buildFormParameters(), (Object)ImmutableMultimap.of());
    }

    @Test
    public void testAddBlockDeviceFromSnapshotStatic() {
        RegisterImageBackedByEbsOptions options = RegisterImageBackedByEbsOptions.Builder.addBlockDeviceFromSnapshot((String)"deviceName", (String)"virtualName", (String)"snapshotId");
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination", (Object)"false", (Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.VirtualName", (Object)"virtualName", (Object)"BlockDeviceMapping.1.Ebs.SnapshotId", (Object)"snapshotId").entries());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testAddBlockDeviceFromSnapshotNPE() {
        RegisterImageBackedByEbsOptions.Builder.addBlockDeviceFromSnapshot(null, null, null);
    }

    @Test
    public void testAddEphemeralBlockDeviceFromSnapshot() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.addEphemeralBlockDeviceFromSnapshot("deviceName", "virtualName", "snapshotId");
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.VirtualName", (Object)"virtualName", (Object)"BlockDeviceMapping.1.Ebs.SnapshotId", (Object)"snapshotId").entries());
    }

    @Test
    public void testAddEphemeralBlockDeviceFromSnapshotNullVirtualName() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.addEphemeralBlockDeviceFromSnapshot("deviceName", null, "snapshotId");
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.Ebs.SnapshotId", (Object)"snapshotId").entries());
    }

    @Test
    public void testNullAddEphemeralBlockDeviceFromSnapshot() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        Assert.assertEquals((Object)options.buildFormParameters(), (Object)ImmutableMultimap.of());
    }

    @Test
    public void testAddEphemeralBlockDeviceFromSnapshotStatic() {
        RegisterImageBackedByEbsOptions options = RegisterImageBackedByEbsOptions.Builder.addEphemeralBlockDeviceFromSnapshot((String)"deviceName", (String)"virtualName", (String)"snapshotId");
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.VirtualName", (Object)"virtualName", (Object)"BlockDeviceMapping.1.Ebs.SnapshotId", (Object)"snapshotId").entries());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testAddEphemeralBlockDeviceFromSnapshotNPE() {
        RegisterImageBackedByEbsOptions.Builder.addEphemeralBlockDeviceFromSnapshot(null, null, null);
    }

    @Test
    public void testAddNewBlockDevice() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.addNewBlockDevice("deviceName", "virtualName", 1);
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination", (Object)"false", (Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.VirtualName", (Object)"virtualName", (Object)"BlockDeviceMapping.1.Ebs.VolumeSize", (Object)"1").entries());
    }

    @Test
    public void testAddNewBlockDeviceNullVirtualName() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.addNewBlockDevice("deviceName", null, 1);
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination", (Object)"false", (Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.Ebs.VolumeSize", (Object)"1").entries());
    }

    @Test
    public void testNullAddNewBlockDevice() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        Assert.assertEquals((Object)options.buildFormParameters(), (Object)ImmutableMultimap.of());
    }

    @Test
    public void testAddNewBlockDeviceStatic() {
        RegisterImageBackedByEbsOptions options = RegisterImageBackedByEbsOptions.Builder.addNewBlockDevice((String)"deviceName", (String)"virtualName", (int)1);
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.Ebs.DeleteOnTermination", (Object)"false", (Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.VirtualName", (Object)"virtualName", (Object)"BlockDeviceMapping.1.Ebs.VolumeSize", (Object)"1").entries());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testAddNewBlockDeviceNPE() {
        RegisterImageBackedByEbsOptions.Builder.addNewBlockDevice(null, null, (int)1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAddNewBlockDeviceTooBig() {
        RegisterImageBackedByEbsOptions.Builder.addNewBlockDevice((String)"deviceName", (String)"virtualName", (int)1025);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAddNewBlockDeviceTooSmall() {
        RegisterImageBackedByEbsOptions.Builder.addNewBlockDevice((String)"deviceName", (String)"virtualName", (int)0);
    }

    @Test
    public void testAddNewEphemeralBlockDevice() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.addNewEphemeralBlockDevice("deviceName", "virtualName", 1);
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.VirtualName", (Object)"virtualName", (Object)"BlockDeviceMapping.1.Ebs.VolumeSize", (Object)"1").entries());
    }

    @Test
    public void testAddNewEphemeralBlockDeviceNullVirtualName() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        options.addNewEphemeralBlockDevice("deviceName", null, 1);
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.Ebs.VolumeSize", (Object)"1").entries());
    }

    @Test
    public void testNullAddNewEphemeralBlockDevice() {
        RegisterImageBackedByEbsOptions options = new RegisterImageBackedByEbsOptions();
        Assert.assertEquals((Object)options.buildFormParameters(), (Object)ImmutableMultimap.of());
    }

    @Test
    public void testAddNewEphemeralBlockDeviceStatic() {
        RegisterImageBackedByEbsOptions options = RegisterImageBackedByEbsOptions.Builder.addNewEphemeralBlockDevice((String)"deviceName", (String)"virtualName", (int)1);
        Assert.assertEquals((Collection)options.buildFormParameters().entries(), (Collection)ImmutableMultimap.of((Object)"BlockDeviceMapping.1.DeviceName", (Object)"deviceName", (Object)"BlockDeviceMapping.1.VirtualName", (Object)"virtualName", (Object)"BlockDeviceMapping.1.Ebs.VolumeSize", (Object)"1").entries());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testAddNewEphemeralBlockDeviceNPE() {
        RegisterImageBackedByEbsOptions.Builder.addNewEphemeralBlockDevice(null, null, (int)1);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAddNewEphemeralBlockDeviceTooBig() {
        RegisterImageBackedByEbsOptions.Builder.addNewEphemeralBlockDevice((String)"deviceName", (String)"virtualName", (int)1025);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testAddNewEphemeralBlockDeviceTooSmall() {
        RegisterImageBackedByEbsOptions.Builder.addNewEphemeralBlockDevice((String)"deviceName", (String)"virtualName", (int)0);
    }
}

