/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.ec2.options.DescribeRegionsOptions;
import org.jclouds.ec2.services.AvailabilityZoneAndRegionClient;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="AvailabilityZoneAndRegionClientLiveTest")
public class AvailabilityZoneAndRegionClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Client ec2Client;
    private AvailabilityZoneAndRegionClient client;

    public AvailabilityZoneAndRegionClientLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Client = (EC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi();
        this.client = this.ec2Client.getAvailabilityZoneAndRegionServices();
    }

    public void testDescribeAvailabilityZones() {
        for (String region : this.ec2Client.getConfiguredRegions()) {
            Set allResults = this.client.describeAvailabilityZonesInRegion(region, new DescribeAvailabilityZonesOptions[0]);
            Assert.assertNotNull((Object)allResults);
            assert (allResults.size() >= 1) : allResults.size();
            Iterator iterator = allResults.iterator();
            String id1 = ((AvailabilityZoneInfo)iterator.next()).getZone();
            Set oneResult = this.client.describeAvailabilityZonesInRegion(region, new DescribeAvailabilityZonesOptions[]{DescribeAvailabilityZonesOptions.Builder.availabilityZones((String[])new String[]{id1})});
            Assert.assertNotNull((Object)oneResult);
            Assert.assertEquals((int)oneResult.size(), (int)1);
            iterator = allResults.iterator();
            Assert.assertEquals((String)((AvailabilityZoneInfo)iterator.next()).getZone(), (String)id1);
        }
    }

    public void testDescribeRegions() {
        TreeMap allResults = Maps.newTreeMap();
        allResults.putAll(this.client.describeRegions(new DescribeRegionsOptions[0]));
        Assert.assertNotNull((Object)allResults);
        assert (allResults.size() >= 1) : allResults.size();
        Iterator iterator = allResults.entrySet().iterator();
        String r1 = (String)iterator.next().getKey();
        TreeMap oneResult = Maps.newTreeMap();
        oneResult.putAll(this.client.describeRegions(new DescribeRegionsOptions[]{DescribeRegionsOptions.Builder.regions((String[])new String[]{r1})}));
        Assert.assertNotNull((Object)oneResult);
        Assert.assertEquals((int)oneResult.size(), (int)1);
        iterator = oneResult.entrySet().iterator();
        Assert.assertEquals((String)((String)iterator.next().getKey()), (String)r1);
    }
}

