/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.internal.BaseEC2ClientExpectTest;
import org.jclouds.ec2.services.ElasticBlockStoreClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="EC2ElasticBlockStoreClientExpectTest")
public class EC2ElasticBlockStoreClientExpectTest
extends BaseEC2ClientExpectTest<EC2Client> {
    Volume creating;

    public EC2ElasticBlockStoreClientExpectTest() {
        this.creating = Volume.builder().id("vol-2a21e543").status(Volume.Status.CREATING).availabilityZone("us-east-1a").region("us-east-1").id("vol-2a21e543").size(1).createTime(this.dateService.iso8601DateParse("2009-12-28T05:42:53.000Z")).build();
    }

    public void testCreateVolumeInAvailabilityZone() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        builder.putAll(this.describeAvailabilityZonesRequestResponse);
        builder.put((Object)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).payload(EC2ElasticBlockStoreClientExpectTest.payloadFromStringWithContentType((String)"Action=CreateVolume&AvailabilityZone=us-east-1a&Signature=FB5hTZHKSAuiygoafIdJh1EnfTu0ogC2VfRQOar85mg%3D&SignatureMethod=HmacSHA256&SignatureVersion=2&Size=4&Timestamp=2012-04-16T15%3A54%3A08.897Z&Version=2010-06-15&AWSAccessKeyId=identity", (String)"application/x-www-form-urlencoded"))).build(), (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/created_volume.xml"))).build());
        ElasticBlockStoreClient client = ((EC2Client)this.requestsSendResponses((Map)builder.build())).getElasticBlockStoreServices();
        Assert.assertEquals((Object)client.createVolumeInAvailabilityZone("us-east-1a", 4), (Object)this.creating);
    }

    public void testCreateVolumeFromSnapshotInAvailabilityZoneEuSetsCorrectEndpoint() {
        String region = "eu-west-1";
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)this.describeRegionsRequest, (Object)this.describeRegionsResponse);
        builder.putAll(this.describeAvailabilityZonesRequestResponse);
        builder.put((Object)this.formSigner.filter(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2." + region + ".amazonaws.com/").addHeader("Host", new String[]{"ec2." + region + ".amazonaws.com"})).addFormParam("Action", new String[]{"CreateVolume"}).addFormParam("AvailabilityZone", new String[]{"eu-west-1a"}).addFormParam("Size", new String[]{"1"}).addFormParam("SnapshotId", new String[]{"snap-8b7ffbdd"}).build()), (Object)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/created_volume.xml"))).build());
        ElasticBlockStoreClient client = ((EC2Client)this.requestsSendResponses((Map)builder.build())).getElasticBlockStoreServices();
        Assert.assertEquals((Object)client.createVolumeFromSnapshotInAvailabilityZone(region + "a", 1, "snap-8b7ffbdd"), (Object)this.creating.toBuilder().region(region).build());
    }
}

