/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.ec2.EC2Fallbacks;
import org.jclouds.ec2.options.CreateSnapshotOptions;
import org.jclouds.ec2.options.DescribeSnapshotsOptions;
import org.jclouds.ec2.options.DetachVolumeOptions;
import org.jclouds.ec2.services.BaseEC2AsyncClientTest;
import org.jclouds.ec2.services.ElasticBlockStoreAsyncClient;
import org.jclouds.ec2.xml.AttachmentHandler;
import org.jclouds.ec2.xml.DescribeSnapshotsResponseHandler;
import org.jclouds.ec2.xml.DescribeVolumesResponseHandler;
import org.jclouds.ec2.xml.PermissionHandler;
import org.jclouds.ec2.xml.SnapshotHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ElasticBlockStoreAsyncClientTest")
public class ElasticBlockStoreAsyncClientTest
extends BaseEC2AsyncClientTest<ElasticBlockStoreAsyncClient> {
    HttpRequest describeVolumes = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DescribeVolumes"}).addFormParam("Signature", new String[]{"hNuorhZQS%2BThX5dWXOvBkvnmTpgp6SvwHmgzjjfKyG8%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest attachVolume = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"AttachVolume"}).addFormParam("Device", new String[]{"/device"}).addFormParam("InstanceId", new String[]{"instanceId"}).addFormParam("Signature", new String[]{"LaOppR61eWpdNgMYJ3ccfo9vzbmUyJf9Ars%2Bbcu4OGI%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-06-15"}).addFormParam("VolumeId", new String[]{"id"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest detachVolume = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DetachVolume"}).addFormParam("Force", new String[]{"false"}).addFormParam("Signature", new String[]{"4c6EmHwCYbe%2BifuUV0PNXpKfReoZvJXyme37mKtnLk8%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-06-15"}).addFormParam("VolumeId", new String[]{"id"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest detachVolumeOptions = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DetachVolume"}).addFormParam("Device", new String[]{"/device"}).addFormParam("Force", new String[]{"true"}).addFormParam("InstanceId", new String[]{"instanceId"}).addFormParam("Signature", new String[]{"GrUGXc6H5W%2BNF8zcXU8gSRbt1ELt%2BTcCDEvbY1a88NE%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2010-06-15"}).addFormParam("VolumeId", new String[]{"id"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest addCreateVolumePermissionsToSnapshot = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ModifySnapshotAttribute"}).addFormParam("Attribute", new String[]{"createVolumePermission"}).addFormParam("OperationType", new String[]{"add"}).addFormParam("Signature", new String[]{"AizV1N1rCCXi%2BbzXX/Vz7shFq9yAJAwcmAGyRQMH%2Bjs%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("SnapshotId", new String[]{"snapshotId"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("UserGroup.1", new String[]{"all"}).addFormParam("UserId.1", new String[]{"bob"}).addFormParam("UserId.2", new String[]{"sue"}).addFormParam("Version", new String[]{"2010-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    HttpRequest removeCreateVolumePermissionsFromSnapshot = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ec2.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"ec2.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ModifySnapshotAttribute"}).addFormParam("Attribute", new String[]{"createVolumePermission"}).addFormParam("OperationType", new String[]{"remove"}).addFormParam("Signature", new String[]{"Lmlt2daM%2BJ4kIoU9HmCempwVGZP1fC6V%2Br9o8MQjYy8%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("SnapshotId", new String[]{"snapshotId"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("UserGroup.1", new String[]{"all"}).addFormParam("UserId.1", new String[]{"bob"}).addFormParam("UserId.2", new String[]{"sue"}).addFormParam("Version", new String[]{"2010-06-15"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testDeleteVolume() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"deleteVolumeInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "id"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DeleteVolume&VolumeId=id", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeVolumes() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"describeVolumesInRegion", (Class[])new Class[]{String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.describeVolumes.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeVolumesResponseHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeVolumesArgs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"describeVolumesInRegion", (Class[])new Class[]{String.class, String[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "1", "2"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeVolumes&VolumeId.1=1&VolumeId.2=2", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeVolumesResponseHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAttachVolume() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"attachVolumeInRegion", (Class[])new Class[]{String.class, String.class, String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "id", "instanceId", "/device"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.attachVolume.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, AttachmentHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDetachVolume() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"detachVolumeInRegion", (Class[])new Class[]{String.class, String.class, Boolean.TYPE, DetachVolumeOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "id", false}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.detachVolume.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, EC2Fallbacks.VoidOnVolumeAvailable.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDetachVolumeOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"detachVolumeInRegion", (Class[])new Class[]{String.class, String.class, Boolean.TYPE, DetachVolumeOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "id", true, DetachVolumeOptions.Builder.fromInstance((String)"instanceId").fromDevice("/device")}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.detachVolumeOptions.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, EC2Fallbacks.VoidOnVolumeAvailable.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateSnapshot() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"createSnapshotInRegion", (Class[])new Class[]{String.class, String.class, CreateSnapshotOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "volumeId"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=CreateSnapshot&VolumeId=volumeId", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, SnapshotHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testCreateSnapshotOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"createSnapshotInRegion", (Class[])new Class[]{String.class, String.class, CreateSnapshotOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "volumeId", CreateSnapshotOptions.Builder.withDescription((String)"description")}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=CreateSnapshot&VolumeId=volumeId&Description=description", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, SnapshotHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeSnapshots() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"describeSnapshotsInRegion", (Class[])new Class[]{String.class, DescribeSnapshotsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeSnapshots", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeSnapshotsResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDescribeSnapshotsArgs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"describeSnapshotsInRegion", (Class[])new Class[]{String.class, DescribeSnapshotsOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, DescribeSnapshotsOptions.Builder.ownedBy((String[])new String[]{"o1", "o2"}).restorableBy(new String[]{"r1", "r2"}).snapshotIds(new String[]{"s1", "s2"})}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeSnapshots&Owner.1=o1&Owner.2=o2&RestorableBy.1=r1&RestorableBy.2=r2&SnapshotId.1=s1&SnapshotId.2=s2", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DescribeSnapshotsResponseHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetCreateVolumePermissionForSnapshot() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"getCreateVolumePermissionForSnapshotInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "snapshotId"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=DescribeSnapshotAttribute&Attribute=createVolumePermission&SnapshotId=snapshotId", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, PermissionHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddCreateVolumePermissionsToSnapshot() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"addCreateVolumePermissionsToSnapshotInRegion", (Class[])new Class[]{String.class, Iterable.class, Iterable.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, ImmutableList.of((Object)"bob", (Object)"sue"), ImmutableList.of((Object)"all"), "snapshotId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.addCreateVolumePermissionsToSnapshot.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testRemoveCreateVolumePermissionsFromSnapshot() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"removeCreateVolumePermissionsFromSnapshotInRegion", (Class[])new Class[]{String.class, Iterable.class, Iterable.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, ImmutableList.of((Object)"bob", (Object)"sue"), ImmutableList.of((Object)"all"), "snapshotId"}));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, this.removeCreateVolumePermissionsFromSnapshot.getPayload().getRawContent().toString(), "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testResetCreateVolumePermissionsOnSnapshot() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(ElasticBlockStoreAsyncClient.class, (String)"resetCreateVolumePermissionsOnSnapshotInRegion", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null, "snapshotId"}));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://ec2.us-east-1.amazonaws.com/ HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Host: ec2.us-east-1.amazonaws.com\n");
        this.assertPayloadEquals((HttpRequest)request, "Action=ResetSnapshotAttribute&Attribute=createVolumePermission&SnapshotId=snapshotId", "application/x-www-form-urlencoded", false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }
}

