/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.domain.Volume;
import org.jclouds.ec2.options.CreateSnapshotOptions;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;
import org.jclouds.ec2.options.DescribeSnapshotsOptions;
import org.jclouds.ec2.predicates.SnapshotCompleted;
import org.jclouds.ec2.predicates.VolumeAvailable;
import org.jclouds.ec2.services.ElasticBlockStoreClient;
import org.jclouds.rest.RestContext;
import org.jclouds.util.Predicates2;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ElasticBlockStoreClientLiveTest")
public class ElasticBlockStoreClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Client ec2Client;
    private ElasticBlockStoreClient client;
    private String defaultRegion;
    private String defaultZone;
    private String volumeId;
    private Snapshot snapshot;

    public ElasticBlockStoreClientLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Client = (EC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi();
        this.client = this.ec2Client.getElasticBlockStoreServices();
        AvailabilityZoneInfo info = (AvailabilityZoneInfo)Iterables.get((Iterable)this.ec2Client.getAvailabilityZoneAndRegionServices().describeAvailabilityZonesInRegion(this.defaultRegion, new DescribeAvailabilityZonesOptions[0]), (int)0);
        this.defaultRegion = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)info.getRegion()), (Object)("region of " + info));
        this.defaultZone = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)info.getZone()), (Object)("zone of " + info));
    }

    @Test
    void testDescribeVolumes() {
        for (String region : this.ec2Client.getConfiguredRegions()) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeVolumesInRegion(region, new String[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            Volume volume = (Volume)allResults.last();
            TreeSet result = Sets.newTreeSet((Iterable)this.client.describeVolumesInRegion(region, new String[]{volume.getId()}));
            Assert.assertNotNull((Object)result);
            Volume compare = (Volume)result.last();
            Assert.assertEquals((Object)compare, (Object)volume);
        }
    }

    @Test
    void testCreateVolumeInAvailabilityZone() {
        Volume expected = this.client.createVolumeInAvailabilityZone(this.defaultZone, 1);
        Assert.assertNotNull((Object)expected);
        Assert.assertEquals((String)expected.getAvailabilityZone(), (String)this.defaultZone);
        this.volumeId = expected.getId();
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)this.client.describeVolumesInRegion(this.defaultRegion, new String[]{expected.getId()}));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Volume volume = (Volume)result.iterator().next();
        Assert.assertEquals((String)volume.getId(), (String)expected.getId());
    }

    @Test(dependsOnMethods={"testCreateVolumeInAvailabilityZone"})
    void testCreateSnapshotInRegion() {
        Snapshot snapshot = this.client.createSnapshotInRegion(this.defaultRegion, this.volumeId, new CreateSnapshotOptions[0]);
        Predicate snapshotted = Predicates2.retry((Predicate)new SnapshotCompleted(this.client), (long)600L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        assert (snapshotted.apply((Object)snapshot));
        Snapshot result = (Snapshot)Iterables.getOnlyElement((Iterable)this.client.describeSnapshotsInRegion(snapshot.getRegion(), new DescribeSnapshotsOptions[]{DescribeSnapshotsOptions.Builder.snapshotIds((String[])new String[]{snapshot.getId()})}));
        Assert.assertEquals((int)result.getProgress(), (int)100);
        this.snapshot = result;
    }

    @Test(dependsOnMethods={"testCreateSnapshotInRegion"})
    void testCreateVolumeFromSnapshotInAvailabilityZone() {
        Volume volume = this.client.createVolumeFromSnapshotInAvailabilityZone(this.defaultZone, this.snapshot.getId());
        Assert.assertNotNull((Object)volume);
        Predicate availabile = Predicates2.retry((Predicate)new VolumeAvailable(this.client), (long)600L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        assert (availabile.apply((Object)volume));
        Volume result = (Volume)Iterables.getOnlyElement((Iterable)this.client.describeVolumesInRegion(this.snapshot.getRegion(), new String[]{volume.getId()}));
        Assert.assertEquals((String)volume.getId(), (String)result.getId());
        Assert.assertEquals((String)volume.getSnapshotId(), (String)this.snapshot.getId());
        Assert.assertEquals((String)volume.getAvailabilityZone(), (String)this.defaultZone);
        Assert.assertEquals((Object)result.getStatus(), (Object)Volume.Status.AVAILABLE);
        this.client.deleteVolumeInRegion(this.snapshot.getRegion(), volume.getId());
    }

    @Test(dependsOnMethods={"testCreateSnapshotInRegion"})
    void testCreateVolumeFromSnapshotInAvailabilityZoneWithSize() {
        Volume volume = this.client.createVolumeFromSnapshotInAvailabilityZone(this.defaultZone, 2, this.snapshot.getId());
        Assert.assertNotNull((Object)volume);
        Predicate availabile = Predicates2.retry((Predicate)new VolumeAvailable(this.client), (long)600L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        assert (availabile.apply((Object)volume));
        Volume result = (Volume)Iterables.getOnlyElement((Iterable)this.client.describeVolumesInRegion(this.snapshot.getRegion(), new String[]{volume.getId()}));
        Assert.assertEquals((String)volume.getId(), (String)result.getId());
        Assert.assertEquals((String)volume.getSnapshotId(), (String)this.snapshot.getId());
        Assert.assertEquals((String)volume.getAvailabilityZone(), (String)this.defaultZone);
        Assert.assertEquals((int)volume.getSize(), (int)2);
        Assert.assertEquals((Object)result.getStatus(), (Object)Volume.Status.AVAILABLE);
        this.client.deleteVolumeInRegion(this.snapshot.getRegion(), volume.getId());
    }

    @Test
    void testAttachVolumeInRegion() {
    }

    @Test
    void testDetachVolumeInRegion() {
    }

    @Test
    void testDescribeSnapshots() {
        for (String region : this.ec2Client.getConfiguredRegions()) {
            TreeSet allResults = Sets.newTreeSet((Iterable)this.client.describeSnapshotsInRegion(region, new DescribeSnapshotsOptions[0]));
            Assert.assertNotNull((Object)allResults);
            if (allResults.size() < 1) continue;
            Snapshot snapshot = (Snapshot)allResults.last();
            Snapshot result = (Snapshot)Iterables.getOnlyElement((Iterable)this.client.describeSnapshotsInRegion(region, new DescribeSnapshotsOptions[]{DescribeSnapshotsOptions.Builder.snapshotIds((String[])new String[]{snapshot.getId()})}));
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)result, (Object)snapshot);
        }
    }

    @Test(enabled=false)
    public void testAddCreateVolumePermissionsToSnapshot() {
    }

    @Test(enabled=false)
    public void testRemoveCreateVolumePermissionsFromSnapshot() {
    }

    @Test(enabled=false)
    public void testResetCreateVolumePermissionsOnSnapshot() {
    }

    @Test(dependsOnMethods={"testCreateSnapshotInRegion"})
    public void testGetCreateVolumePermissionForSnapshot() {
        this.client.getCreateVolumePermissionForSnapshotInRegion(this.snapshot.getRegion(), this.snapshot.getId());
    }

    @Test(dependsOnMethods={"testCreateSnapshotInRegion"})
    void testDeleteVolumeInRegion() {
        this.client.deleteVolumeInRegion(this.defaultRegion, this.volumeId);
        LinkedHashSet result = Sets.newLinkedHashSet((Iterable)this.client.describeVolumesInRegion(this.defaultRegion, new String[]{this.volumeId}));
        Assert.assertEquals((int)result.size(), (int)1);
        Volume volume = (Volume)result.iterator().next();
        Assert.assertEquals((Object)volume.getStatus(), (Object)Volume.Status.DELETING);
    }

    @Test(dependsOnMethods={"testGetCreateVolumePermissionForSnapshot"})
    void testDeleteSnapshotInRegion() {
        this.client.deleteSnapshotInRegion(this.snapshot.getRegion(), this.snapshot.getId());
        assert (this.client.describeSnapshotsInRegion(this.snapshot.getRegion(), new DescribeSnapshotsOptions[]{DescribeSnapshotsOptions.Builder.snapshotIds((String[])new String[]{this.snapshot.getId()})}).size() == 0);
    }
}

