/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.services;

import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.internal.BaseComputeServiceContextLiveTest;
import org.jclouds.ec2.EC2ApiMetadata;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.services.InstanceClient;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="InstanceClientLiveTest")
public class InstanceClientLiveTest
extends BaseComputeServiceContextLiveTest {
    private EC2Client ec2Client;
    private InstanceClient client;

    public InstanceClientLiveTest() {
        this.provider = "ec2";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.ec2Client = (EC2Client)((RestContext)((ComputeServiceContext)this.view).unwrap(EC2ApiMetadata.CONTEXT_TOKEN)).getApi();
        this.client = this.ec2Client.getInstanceServices();
    }

    @Test
    void testDescribeInstances() {
        for (String region : this.ec2Client.getConfiguredRegions()) {
            Set allResults = this.client.describeInstancesInRegion(region, new String[0]);
            Assert.assertNotNull((Object)allResults);
            assert (allResults.size() >= 0) : allResults.size();
        }
    }
}

