/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.xml.BaseEC2HandlerTest;
import org.jclouds.ec2.xml.DescribeInstancesResponseHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.location.Region;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DescribeInstancesResponseHandlerTest")
public class DescribeInstancesResponseHandlerTest
extends BaseEC2HandlerTest {
    private DateService dateService;

    @Override
    @BeforeTest
    protected void setUpInjector() {
        super.setUpInjector();
        this.dateService = (DateService)this.injector.getInstance(DateService.class);
        assert (this.dateService != null);
    }

    public void testWhenRunning() throws UnknownHostException {
        ImmutableSet contents = ImmutableSet.of((Object)new Reservation(this.defaultRegion, (Iterable)ImmutableSet.of((Object)"adriancole.ec2ingress"), (Iterable)ImmutableSet.of((Object)RunningInstance.builder().region(this.defaultRegion).groupName("adriancole.ec2ingress").amiLaunchIndex("0").dnsName("ec2-174-129-81-68.compute-1.amazonaws.com").imageId("ami-82e4b5c7").instanceId("i-0799056f").instanceState(InstanceState.RUNNING).rawState("running").instanceType("m1.small").ipAddress("174.129.81.68").kernelId("aki-a71cf9ce").keyName("adriancole.ec21").launchTime(this.dateService.iso8601DateParse("2009-11-09T03:00:34.000Z")).availabilityZone("us-east-1c").virtualizationType("paravirtual").privateDnsName("ip-10-243-42-70.ec2.internal").privateIpAddress("10.243.42.70").ramdiskId("ari-a51cf9cc").rootDeviceType(RootDeviceType.INSTANCE_STORE).build()), "993194456877", null, "r-a3c508cb"));
        Set<Reservation<? extends RunningInstance>> result = DescribeInstancesResponseHandlerTest.parseRunningInstances("/describe_instances_running.xml");
        Assert.assertEquals((String)result.toString(), (String)contents.toString());
        Assert.assertEquals((Object)((RunningInstance)Iterables.get((Iterable)((Iterable)Iterables.get(result, (int)0)), (int)0)).getInstanceState(), (Object)InstanceState.RUNNING);
        Assert.assertEquals((String)((RunningInstance)Iterables.get((Iterable)((Iterable)Iterables.get(result, (int)0)), (int)0)).getRawState(), (String)"running");
    }

    public void testApplyInputStream() {
        ImmutableSet contents = ImmutableSet.of((Object)new Reservation(this.defaultRegion, (Iterable)ImmutableSet.of((Object)"default"), (Iterable)ImmutableSet.of((Object)RunningInstance.builder().region(this.defaultRegion).groupName("default").amiLaunchIndex("23").dnsName("ec2-72-44-33-4.compute-1.amazonaws.com").imageId("ami-6ea54007").instanceId("i-28a64341").instanceState(InstanceState.RUNNING).rawState("running").instanceType("m1.large").kernelId("aki-ba3adfd3").keyName("example-key-name").launchTime(this.dateService.iso8601DateParse("2007-08-07T11:54:42.000Z")).availabilityZone("us-east-1b").virtualizationType("paravirtual").privateDnsName("10-251-50-132.ec2.internal").tags((Map)ImmutableMap.of((Object)"Name", (Object)"ec2-o", (Object)"Empty", (Object)"")).ramdiskId("ari-badbad00").rootDeviceType(RootDeviceType.INSTANCE_STORE).build(), (Object)RunningInstance.builder().region(this.defaultRegion).groupName("default").amiLaunchIndex("23").dnsName("ec2-72-44-33-6.compute-1.amazonaws.com").imageId("ami-6ea54007").instanceId("i-28a64435").instanceState(InstanceState.RUNNING).rawState("running").instanceType("m1.large").kernelId("aki-ba3adfd3").keyName("example-key-name").launchTime(this.dateService.iso8601DateParse("2007-08-07T11:54:42.000Z")).availabilityZone("us-east-1b").virtualizationType("paravirtual").privateDnsName("10-251-50-134.ec2.internal").ramdiskId("ari-badbad00").rootDeviceType(RootDeviceType.INSTANCE_STORE).build()), "UYY3TLBUXIEON5NQVUUX6OMPWBZIQNFM", null, "r-44a5402d"));
        Set<Reservation<? extends RunningInstance>> result = DescribeInstancesResponseHandlerTest.parseRunningInstances("/describe_instances.xml");
        Assert.assertEquals((String)result.toString(), (String)contents.toString());
        Assert.assertEquals((Object)((RunningInstance)Iterables.get((Iterable)((Iterable)Iterables.get(result, (int)0)), (int)0)).getInstanceState(), (Object)InstanceState.RUNNING);
        Assert.assertEquals((String)((RunningInstance)Iterables.get((Iterable)((Iterable)Iterables.get(result, (int)0)), (int)0)).getRawState(), (String)"running");
    }

    public void testEBS() throws UnknownHostException {
        ImmutableSet contents = ImmutableSet.of((Object)new Reservation(this.defaultRegion, (Iterable)ImmutableSet.of((Object)"adriancole.ec2ebsingress"), (Iterable)ImmutableSet.of((Object)RunningInstance.builder().region(this.defaultRegion).groupName("adriancole.ec2ebsingress").amiLaunchIndex("0").dnsName("ec2-75-101-203-146.compute-1.amazonaws.com").imageId("ami-849875ed").instanceId("i-e564438d").instanceState(InstanceState.RUNNING).rawState("running").instanceType("m1.small").ipAddress("75.101.203.146").kernelId("aki-a71cf9ce").keyName("adriancole.ec2ebs1").launchTime(this.dateService.iso8601DateParse("2009-12-30T04:06:23.000Z")).availabilityZone("us-east-1b").virtualizationType("hvm").privateDnsName("domU-12-31-39-09-CE-53.compute-1.internal").privateIpAddress("10.210.209.157").ramdiskId("ari-a51cf9cc").rootDeviceType(RootDeviceType.EBS).rootDeviceName("/dev/sda1").device("/dev/sda1", new BlockDevice("vol-dc6ca8b5", Attachment.Status.ATTACHED, this.dateService.iso8601DateParse("2009-12-30T04:06:29.000Z"), true)).build()), "993194456877", null, "r-596dd731"));
        Set<Reservation<? extends RunningInstance>> result = DescribeInstancesResponseHandlerTest.parseRunningInstances("/describe_instances_ebs.xml");
        Assert.assertEquals((String)result.toString(), (String)contents.toString());
        Assert.assertEquals((Object)((RunningInstance)Iterables.get((Iterable)((Iterable)Iterables.get(result, (int)0)), (int)0)).getInstanceState(), (Object)InstanceState.RUNNING);
        Assert.assertEquals((String)((RunningInstance)Iterables.get((Iterable)((Iterable)Iterables.get(result, (int)0)), (int)0)).getRawState(), (String)"running");
    }

    static ParseSax<Set<Reservation<? extends RunningInstance>>> createParser() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<String>>(){}).annotatedWith(Region.class).toInstance((Object)Suppliers.ofInstance((Object)"us-east-1"));
            }
        }});
        ParseSax parser = ((ParseSax.Factory)injector.getInstance(ParseSax.Factory.class)).create((ParseSax.HandlerWithResult)injector.getInstance(DescribeInstancesResponseHandler.class));
        return parser;
    }

    public static Set<Reservation<? extends RunningInstance>> parseRunningInstances(String resource) {
        InputStream is = DescribeInstancesResponseHandlerTest.class.getResourceAsStream(resource);
        return (Set)DescribeInstancesResponseHandlerTest.createParser().parse(is);
    }
}

