/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2;

import com.google.common.base.Optional;
import com.google.inject.Provides;
import java.io.Closeable;
import java.util.Set;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.ec2.features.AvailabilityZoneAndRegionApi;
import org.jclouds.ec2.features.ElasticBlockStoreApi;
import org.jclouds.ec2.features.ElasticIPAddressApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.features.KeyPairApi;
import org.jclouds.ec2.features.SecurityGroupApi;
import org.jclouds.ec2.features.SubnetApi;
import org.jclouds.ec2.features.TagApi;
import org.jclouds.ec2.features.WindowsApi;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Region;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.annotations.EndpointParam;

public interface EC2Api
extends Closeable {
    @Provides
    @Region
    public Set<String> getConfiguredRegions();

    @Delegate
    public Optional<? extends WindowsApi> getWindowsApi();

    @Delegate
    public Optional<? extends WindowsApi> getWindowsApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Delegate
    public Optional<? extends TagApi> getTagApi();

    @Delegate
    public Optional<? extends TagApi> getTagApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Delegate
    public Optional<? extends SubnetApi> getSubnetApi();

    @Delegate
    public Optional<? extends SubnetApi> getSubnetApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Delegate
    public Optional<? extends AMIApi> getAMIApi();

    @Delegate
    public Optional<? extends AMIApi> getAMIApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Delegate
    public Optional<? extends AvailabilityZoneAndRegionApi> getAvailabilityZoneAndRegionApi();

    @Delegate
    public Optional<? extends AvailabilityZoneAndRegionApi> getAvailabilityZoneAndRegionApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Delegate
    public Optional<? extends ElasticBlockStoreApi> getElasticBlockStoreApi();

    @Delegate
    public Optional<? extends ElasticBlockStoreApi> getElasticBlockStoreApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Delegate
    public Optional<? extends ElasticIPAddressApi> getElasticIPAddressApi();

    @Delegate
    public Optional<? extends ElasticIPAddressApi> getElasticIPAddressApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Delegate
    public Optional<? extends InstanceApi> getInstanceApi();

    @Delegate
    public Optional<? extends InstanceApi> getInstanceApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Delegate
    public Optional<? extends KeyPairApi> getKeyPairApi();

    @Delegate
    public Optional<? extends KeyPairApi> getKeyPairApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);

    @Delegate
    public Optional<? extends SecurityGroupApi> getSecurityGroupApi();

    @Delegate
    public Optional<? extends SecurityGroupApi> getSecurityGroupApiForRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1);
}

