/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.ec2.EC2AsyncClient;
import org.jclouds.ec2.EC2Client;
import org.jclouds.ec2.compute.EC2ComputeServiceContext;
import org.jclouds.ec2.compute.config.EC2ComputeServiceContextModule;
import org.jclouds.ec2.compute.config.EC2ResolveImagesModule;
import org.jclouds.ec2.config.EC2RestClientModule;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;

public class EC2ApiMetadata
extends BaseRestApiMetadata {
    @Deprecated
    public static final TypeToken<RestContext<? extends EC2Client, ? extends EC2AsyncClient>> CONTEXT_TOKEN = new TypeToken<RestContext<? extends EC2Client, ? extends EC2AsyncClient>>(){
        private static final long serialVersionUID = 1L;
    };

    public Builder<?> toBuilder() {
        return (Builder)new ConcreteBuilder().fromApiMetadata((ApiMetadata)this);
    }

    public EC2ApiMetadata() {
        this(new ConcreteBuilder());
    }

    protected EC2ApiMetadata(Builder<?> builder) {
        super(builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        properties.setProperty("jclouds.ec2.ami-owners", "*");
        properties.setProperty("jclouds.ec2.timeout.securitygroup-present", "500");
        properties.setProperty("jclouds.ec2.auto-allocate-elastic-ips", "false");
        properties.setProperty("jclouds.compute.resourcename-delimiter", "#");
        properties.setProperty("jclouds.ec2.generate-instance-names", "true");
        return properties;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseRestApiMetadata.Builder<T> {
        protected Builder() {
            this(EC2Client.class, EC2AsyncClient.class);
        }

        protected Builder(Class<?> syncClient, Class<?> asyncClient) {
            super(syncClient, asyncClient);
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("ec2")).name("Amazon Elastic Compute Cloud (EC2) API")).identityName("Access Key ID")).credentialName("Secret Access Key")).defaultEndpoint("https://ec2.us-east-1.amazonaws.com")).documentation(URI.create("http://docs.amazonwebservices.com/AWSEC2/latest/APIReference"))).version("2010-06-15")).defaultProperties(EC2ApiMetadata.defaultProperties())).context(CONTEXT_TOKEN)).view(EC2ComputeServiceContext.class)).defaultModules((Set)ImmutableSet.of(EC2RestClientModule.class, EC2ResolveImagesModule.class, EC2ComputeServiceContextModule.class));
        }

        public ApiMetadata build() {
            return new EC2ApiMetadata(this);
        }
    }
}

