/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.ec2.domain.IpPermission;
import org.jclouds.javax.annotation.Nullable;

public class SecurityGroup
extends ForwardingSet<IpPermission> {
    private final String region;
    private final String id;
    private final String name;
    private final String ownerId;
    private final String description;
    private final Set<IpPermission> ipPermissions;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSecurityGroup(this);
    }

    public SecurityGroup(String region, String id, String name, String ownerId, String description, Iterable<IpPermission> ipPermissions) {
        this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"region");
        this.id = id;
        this.name = name;
        this.ownerId = ownerId;
        this.description = description;
        this.ipPermissions = ImmutableSet.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(ipPermissions, (Object)"ipPermissions")));
    }

    @Deprecated
    public String getRegion() {
        return this.region;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.region, this.id, this.name, this.ownerId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SecurityGroup that = (SecurityGroup)((Object)SecurityGroup.class.cast(obj));
        return Objects.equal((Object)this.region, (Object)that.region) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.ownerId, (Object)that.ownerId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)((Object)this)).omitNullValues().add("region", (Object)this.region).add("id", (Object)this.id).add("name", (Object)this.name).add("ownerId", (Object)this.ownerId).add("description", (Object)this.description).add("ipPermissions", this.ipPermissions.size() == 0 ? null : this.ipPermissions);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Set<IpPermission> delegate() {
        return this.ipPermissions;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String region;
        protected String id;
        protected String name;
        protected String ownerId;
        protected String description;
        protected ImmutableSet.Builder<IpPermission> ipPermissions = ImmutableSet.builder();

        protected abstract T self();

        public T region(String region) {
            this.region = region;
            return this.self();
        }

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this.self();
        }

        public T description(String description) {
            this.description = description;
            return this.self();
        }

        public T role(IpPermission role) {
            this.ipPermissions.add((Object)role);
            return this.self();
        }

        public T ipPermissions(Iterable<IpPermission> ipPermissions) {
            this.ipPermissions.addAll((Iterable)Preconditions.checkNotNull(ipPermissions, (Object)"ipPermissions"));
            return this.self();
        }

        public T ipPermission(IpPermission ipPermission) {
            this.ipPermissions.add(Preconditions.checkNotNull((Object)ipPermission, (Object)"ipPermission"));
            return this.self();
        }

        public SecurityGroup build() {
            return new SecurityGroup(this.region, this.id, this.name, this.ownerId, this.description, (Iterable<IpPermission>)this.ipPermissions.build());
        }

        public T fromSecurityGroup(SecurityGroup in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.region(in.region)).id(in.id)).name(in.name)).ownerId(in.ownerId)).description(in.description)).ipPermissions((Iterable<IpPermission>)((Object)in));
        }
    }
}

