/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.ec2.domain.Hypervisor;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.VirtualizationType;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DescribeImagesResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Set<Image>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected Set<Image> contents = Sets.newLinkedHashSet();
    private StringBuilder currentText = new StringBuilder();
    private final Supplier<String> defaultRegion;
    private Image.Architecture architecture;
    private String name;
    private String description;
    private String imageId;
    private String imageLocation;
    private String imageOwnerId;
    private Image.ImageState imageState;
    private String rawState;
    private Image.ImageType imageType;
    private boolean isPublic;
    private String kernelId;
    private String platform;
    private Set<String> productCodes = Sets.newHashSet();
    private String ramdiskId;
    private boolean inProductCodes;
    private boolean inBlockDeviceMapping;
    private RootDeviceType rootDeviceType = RootDeviceType.INSTANCE_STORE;
    private Map<String, Image.EbsBlockDevice> ebsBlockDevices = Maps.newHashMap();
    private String deviceName;
    private String snapshotId;
    private VirtualizationType virtualizationType = VirtualizationType.PARAVIRTUAL;
    private Hypervisor hypervisor = Hypervisor.XEN;
    private int volumeSize;
    private boolean deleteOnTermination = true;
    private String rootDeviceName;

    @Inject
    public DescribeImagesResponseHandler(@Region Supplier<String> defaultRegion) {
        this.defaultRegion = defaultRegion;
    }

    public Set<Image> getResult() {
        return this.contents;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("productCodes")) {
            this.inProductCodes = true;
        } else if (qName.equals("blockDeviceMapping")) {
            this.inBlockDeviceMapping = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("architecture")) {
            this.architecture = Image.Architecture.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("name") || qName.equals("displayName")) {
            this.name = this.currentText.toString().trim();
        } else if (qName.equals("description")) {
            this.description = this.currentText.toString().trim();
        } else if (qName.equals("imageId")) {
            this.imageId = this.currentText.toString().trim();
        } else if (qName.equals("deviceName")) {
            this.deviceName = this.currentText.toString().trim();
        } else if (qName.equals("imageLocation")) {
            this.imageLocation = this.currentText.toString().trim();
        } else if (qName.equals("imageOwnerId")) {
            this.imageOwnerId = this.currentText.toString().trim();
        } else if (qName.equals("imageState")) {
            this.rawState = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            this.imageState = Image.ImageState.fromValue(this.rawState);
        } else if (qName.equals("imageType")) {
            this.imageType = Image.ImageType.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("isPublic")) {
            this.isPublic = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (qName.equals("kernelId")) {
            this.kernelId = this.currentText.toString().trim();
        } else if (qName.equals("platform")) {
            this.platform = this.currentText.toString().trim();
        } else if (qName.equals("productCode")) {
            this.productCodes.add(this.currentText.toString().trim());
        } else if (qName.equals("productCodes")) {
            this.inProductCodes = false;
        } else if (qName.equals("blockDeviceMapping")) {
            this.inBlockDeviceMapping = false;
        } else if (qName.equals("snapshotId")) {
            this.snapshotId = this.currentText.toString().trim();
        } else if (qName.equals("volumeSize")) {
            this.volumeSize = Integer.parseInt(this.currentText.toString().trim());
        } else if (qName.equals("deleteOnTermination")) {
            this.deleteOnTermination = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (qName.equals("ramdiskId")) {
            this.ramdiskId = this.currentText.toString().trim();
        } else if (qName.equals("rootDeviceType")) {
            this.rootDeviceType = RootDeviceType.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("rootDeviceName")) {
            this.rootDeviceName = this.currentText.toString().trim();
        } else if (qName.equals("virtualizationType")) {
            this.virtualizationType = VirtualizationType.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("hypervisor")) {
            this.hypervisor = Hypervisor.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("item")) {
            if (this.inBlockDeviceMapping) {
                this.ebsBlockDevices.put(this.deviceName, new Image.EbsBlockDevice(this.snapshotId, this.volumeSize, this.deleteOnTermination));
                this.deviceName = null;
                this.snapshotId = null;
                this.volumeSize = 0;
                this.deleteOnTermination = true;
            } else if (!this.inProductCodes) {
                try {
                    String region;
                    String string = region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest()) : null;
                    if (region == null) {
                        region = (String)this.defaultRegion.get();
                    }
                    this.contents.add(new Image(region, this.architecture, this.name, this.description, this.imageId, this.imageLocation, this.imageOwnerId, this.imageState, this.rawState, this.imageType, this.isPublic, this.productCodes, this.kernelId, this.platform, this.ramdiskId, this.rootDeviceType, this.rootDeviceName, this.ebsBlockDevices, this.virtualizationType, this.hypervisor));
                }
                catch (NullPointerException e) {
                    this.logger.warn((Throwable)e, "malformed image: %s", new Object[]{this.imageId});
                }
                this.name = null;
                this.description = null;
                this.architecture = null;
                this.imageId = null;
                this.imageLocation = null;
                this.imageOwnerId = null;
                this.imageState = null;
                this.rawState = null;
                this.imageType = null;
                this.isPublic = false;
                this.kernelId = null;
                this.platform = null;
                this.productCodes = Sets.newHashSet();
                this.ramdiskId = null;
                this.rootDeviceType = RootDeviceType.INSTANCE_STORE;
                this.rootDeviceName = null;
                this.ebsBlockDevices = Maps.newHashMap();
                this.virtualizationType = VirtualizationType.PARAVIRTUAL;
                this.hypervisor = Hypervisor.XEN;
            }
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

