/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.cinder.v1.CinderApi;
import org.jclouds.openstack.cinder.v1.domain.Volume;
import org.jclouds.openstack.cinder.v1.domain.VolumeAttachment;
import org.jclouds.openstack.cinder.v1.features.VolumeApi;
import org.jclouds.openstack.cinder.v1.internal.BaseCinderApiExpectTest;
import org.jclouds.openstack.cinder.v1.options.CreateVolumeOptions;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VolumeApiExpectTest")
public class VolumeApiExpectTest
extends BaseCinderApiExpectTest {
    private DateService dateService = new SimpleDateFormatDateService();

    public void testListVolumes() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_list_simple.json"))).build())).getVolumeApiForZone("RegionOne");
        ImmutableSet volumes = api.list().toSet();
        Assert.assertEquals((Set)volumes, (Set)ImmutableSet.of((Object)this.testVolume()));
    }

    public void testListVolumesFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeApiForZone("RegionOne");
        ImmutableSet volumes = api.list().toSet();
        Assert.assertTrue((boolean)volumes.isEmpty());
    }

    public void testListVolumesInDetail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes/detail");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_list_details.json"))).build())).getVolumeApiForZone("RegionOne");
        ImmutableSet volumes = api.listInDetail().toSet();
        Assert.assertEquals((Set)volumes, (Set)ImmutableSet.of((Object)this.testVolume()));
    }

    public void testListVolumesInDetailFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes/detail");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeApiForZone("RegionOne");
        ImmutableSet volumes = api.listInDetail().toSet();
        Assert.assertTrue((boolean)volumes.isEmpty());
    }

    public void testCreateVolume() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).method("POST").payload(this.payloadFromResourceWithContentType("/volume_create.json", "application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_create_response.json"))).build())).getVolumeApiForZone("RegionOne");
        CreateVolumeOptions options = CreateVolumeOptions.Builder.name((String)"jclouds-test-volume").description("description of test volume");
        Volume volume = api.create(1, new CreateVolumeOptions[]{options});
        Assert.assertEquals((Object)volume, (Object)this.testVolumeCreate());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testCreateVolumeFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)this.authenticatedGET().endpoint(endpoint).endpoint(endpoint).method("POST").payload(this.payloadFromResourceWithContentType("/volume_create.json", "application/json"))).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResource("/volume_create_response.json"))).build())).getVolumeApiForZone("RegionOne");
        CreateVolumeOptions options = CreateVolumeOptions.Builder.name((String)"jclouds-test-volume").description("description of test volume");
        api.create(1, new CreateVolumeOptions[]{options});
    }

    public void testGetVolume() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes/60761c60-0f56-4499-b522-ff13e120af10");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/volume_get.json"))).build())).getVolumeApiForZone("RegionOne");
        Volume volume = api.get("60761c60-0f56-4499-b522-ff13e120af10");
        Assert.assertEquals((Object)volume, (Object)this.testVolume());
        Assert.assertEquals((String)volume.getName(), (String)"test");
        Assert.assertEquals((String)volume.getZone(), (String)"nova");
        Assert.assertEquals((Object)volume.getStatus(), (Object)Volume.Status.IN_USE);
        Assert.assertEquals((String)volume.getDescription(), (String)"This is a test volume");
        Assert.assertEquals((Object)Iterables.getOnlyElement((Iterable)volume.getAttachments()), (Object)this.testAttachment());
    }

    public void testGetVolumeFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes/60761c60-0f56-4499-b522-ff13e120af10");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).build(), HttpResponse.builder().statusCode(404).build())).getVolumeApiForZone("RegionOne");
        Assert.assertNull((Object)api.get("60761c60-0f56-4499-b522-ff13e120af10"));
    }

    public void testDeleteVolume() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes/60761c60-0f56-4499-b522-ff13e120af10");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(202).build())).getVolumeApiForZone("RegionOne");
        Assert.assertTrue((boolean)api.delete("60761c60-0f56-4499-b522-ff13e120af10"));
    }

    public void testDeleteVolumeFail() {
        URI endpoint = URI.create("http://172.16.0.1:8776/v1/50cdb4c60374463198695d9f798fa34d/volumes/60761c60-0f56-4499-b522-ff13e120af10");
        VolumeApi api = ((CinderApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, this.authenticatedGET().endpoint(endpoint).method("DELETE").build(), HttpResponse.builder().statusCode(404).build())).getVolumeApiForZone("RegionOne");
        Assert.assertFalse((boolean)api.delete("60761c60-0f56-4499-b522-ff13e120af10"));
    }

    protected Volume testVolumeCreate() {
        return Volume.builder().id("60761c60-0f56-4499-b522-ff13e120af10").size(1).name("jclouds-test-volume").zone("nova").status(Volume.Status.CREATING).volumeType("None").description("description of test volume").created(this.dateService.iso8601DateParse("2012-10-29T20:53:28.000000")).build();
    }

    protected Volume testVolume() {
        return Volume.builder().id("60761c60-0f56-4499-b522-ff13e120af10").size(1).name("test").zone("nova").status(Volume.Status.IN_USE).volumeType("None").description("This is a test volume").attachments((Set)ImmutableSet.of((Object)this.testAttachment())).created(this.dateService.iso8601DateParse("2012-10-29T20:53:28.000000")).build();
    }

    protected VolumeAttachment testAttachment() {
        return VolumeAttachment.builder().id("60761c60-0f56-4499-b522-ff13e120af10").volumeId("60761c60-0f56-4499-b522-ff13e120af10").serverId("0229a1c1-d54a-4836-8527-2ab28b42e2bb").device("/dev/vdc").build();
    }
}

