/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.cinder.v1.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provides;
import java.net.URI;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.cinder.v1.CinderApi;
import org.jclouds.openstack.cinder.v1.CinderAsyncApi;
import org.jclouds.openstack.cinder.v1.features.SnapshotApi;
import org.jclouds.openstack.cinder.v1.features.SnapshotAsyncApi;
import org.jclouds.openstack.cinder.v1.features.VolumeApi;
import org.jclouds.openstack.cinder.v1.features.VolumeAsyncApi;
import org.jclouds.openstack.cinder.v1.features.VolumeTypeApi;
import org.jclouds.openstack.cinder.v1.features.VolumeTypeAsyncApi;
import org.jclouds.openstack.cinder.v1.handlers.CinderErrorHandler;
import org.jclouds.openstack.v2_0.features.ExtensionApi;
import org.jclouds.openstack.v2_0.features.ExtensionAsyncApi;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
public class CinderRestClientModule<S extends CinderApi, A extends CinderAsyncApi>
extends RestClientModule<S, A> {
    public static final Map<Class<?>, Class<?>> DELEGATE_MAP = ImmutableMap.builder().put(ExtensionApi.class, ExtensionAsyncApi.class).put(VolumeApi.class, VolumeAsyncApi.class).put(VolumeTypeApi.class, VolumeTypeAsyncApi.class).put(SnapshotApi.class, SnapshotAsyncApi.class).build();

    public CinderRestClientModule() {
        super((TypeToken)TypeToken.class.cast(Reflection2.typeToken(CinderApi.class)), (TypeToken)TypeToken.class.cast(Reflection2.typeToken(CinderAsyncApi.class)), DELEGATE_MAP);
    }

    protected CinderRestClientModule(TypeToken<S> syncClientType, TypeToken<A> asyncClientType, Map<Class<?>, Class<?>> sync2Async) {
        super(syncClientType, asyncClientType, sync2Async);
    }

    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
    }

    @Provides
    @Singleton
    public Multimap<URI, URI> aliases() {
        return ImmutableMultimap.builder().build();
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(CinderErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(CinderErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(CinderErrorHandler.class);
    }
}

