/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0;

import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.ApiMetadata;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneRestApiExpectTest;
import org.jclouds.openstack.keystone.v2_0.parse.ParseRackspaceApiMetadataTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="KeystoneApiExpectTest")
public class KeystoneApiExpectTest
extends BaseKeystoneRestApiExpectTest<KeystoneApi> {
    public void testGetApiMetaData() {
        KeystoneApi api = (KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(this.endpoint + "/v2.0/").addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/raxVersion.json", "application/json"))).build());
        ApiMetadata metadata = api.getApiMetadata();
        Assert.assertEquals((Object)metadata, (Object)new ParseRackspaceApiMetadataTest().expected());
    }

    public void testGetApiMetaDataFailNotFound() {
        KeystoneApi api = (KeystoneApi)this.requestsSendResponses(this.keystoneAuthWithUsernameAndPasswordAndTenantName, this.responseWithKeystoneAccess, ((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(this.endpoint + "/v2.0/").addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)api.getApiMetadata());
    }
}

