/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.openstack.keystone.v2_0.KeystoneApi;
import org.jclouds.openstack.keystone.v2_0.domain.Role;
import org.jclouds.openstack.keystone.v2_0.domain.Tenant;
import org.jclouds.openstack.keystone.v2_0.domain.User;
import org.jclouds.openstack.keystone.v2_0.features.TenantApi;
import org.jclouds.openstack.keystone.v2_0.features.UserApi;
import org.jclouds.openstack.keystone.v2_0.internal.BaseKeystoneApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="UserApiLiveTest", singleThreaded=true)
public class UserApiLiveTest
extends BaseKeystoneApiLiveTest {
    public void testUsers() {
        UserApi userApi = (UserApi)((KeystoneApi)this.api).getUserApi().get();
        ImmutableSet users = userApi.list().concat().toSet();
        Assert.assertNotNull((Object)users);
        Assert.assertFalse((boolean)users.isEmpty());
        for (User user : users) {
            User aUser = userApi.get(user.getId());
            Assert.assertEquals((Set)aUser, (Set)user);
        }
    }

    public void testUserRolesOnTenant() {
        UserApi userApi = (UserApi)((KeystoneApi)this.api).getUserApi().get();
        ImmutableSet tenants = ((TenantApi)((KeystoneApi)this.api).getTenantApi().get()).list().concat().toSet();
        for (User user : userApi.list().concat()) {
            for (Tenant tenant : tenants) {
                Set roles = userApi.listRolesOfUserOnTenant(user.getId(), tenant.getId());
                for (Role role : roles) {
                    Assert.assertNotNull((Object)role.getId());
                }
            }
        }
    }

    public void testListRolesOfUser() {
        UserApi userApi = (UserApi)((KeystoneApi)this.api).getUserApi().get();
        for (User user : userApi.list().concat()) {
            Set roles = userApi.listRolesOfUser(user.getId());
            for (Role role : roles) {
                Assert.assertNotNull((Object)role.getId());
            }
        }
    }

    public void testUsersByName() {
        UserApi userApi = (UserApi)((KeystoneApi)this.api).getUserApi().get();
        for (User user : userApi.list().concat()) {
            User aUser = userApi.getByName(user.getName());
            Assert.assertEquals((Set)aUser, (Set)user);
        }
    }
}

